/*
 * Decompiled with CFR 0.152.
 */
package cn.zeroup.macrocosm.service;

import cn.vertxup.workflow.domain.tables.daos.WFlowDao;
import cn.zeroup.macrocosm.service.FlowStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.ui.Form;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.runner.StoreOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class FlowService
implements FlowStub {
    @Override
    public Future<JsonObject> fetchFlow(String definitionKey, String sigma) {
        StoreOn storeOn = StoreOn.get();
        return Wf.processByKey(definitionKey).compose(storeOn::workflowGet).compose(definition -> {
            JsonObject condition = Ux.whereAnd();
            condition.put("code", (Object)definitionKey);
            condition.put("sigma", (Object)sigma);
            return Ux.Jooq.on(WFlowDao.class).fetchJOneAsync(condition).compose(workflow -> {
                JsonObject response = new JsonObject();
                response.mergeIn(workflow);
                response.mergeIn(definition);
                return (Future)Ut.ifJObject((String[])new String[]{"startConfig", "authorizedConfig", "endConfig", "runConfig", "generateConfig", "uiConfig", "uiAssist", "uiLinkage"}).apply(response);
            });
        });
    }

    @Override
    public Future<JsonObject> fetchFormStart(ProcessDefinition definition, String sigma) {
        StoreOn storeOn = StoreOn.get();
        return storeOn.formGet(definition).compose(formData -> this.fetchFormInternal((JsonObject)formData, sigma)).compose(response -> storeOn.workflowGet(definition).compose(Ux.attachJ((String)"workflow", (JsonObject)response)));
    }

    @Override
    public Future<JsonObject> fetchForm(ProcessDefinition definition, ProcessInstance instance, String sigma) {
        StoreOn storeOn = StoreOn.get();
        return storeOn.formGet(definition, instance).compose(formData -> this.fetchFormInternal((JsonObject)formData, sigma)).compose(response -> storeOn.workflowGet(definition, instance).compose(Ux.attachJ((String)"workflow", (JsonObject)response)));
    }

    @Override
    public Future<JsonObject> fetchFormEnd(ProcessDefinition definition, HistoricProcessInstance instance, String sigma) {
        StoreOn storeOn = StoreOn.get();
        JsonObject response = new JsonObject();
        return storeOn.workflowGet(definition, instance).compose(Ux.attachJ((String)"workflow", (JsonObject)response)).compose(processed -> {
            JsonObject workflow = Ut.valueJObject((JsonObject)processed.getJsonObject("workflow"));
            JsonObject formData = workflow.copy();
            formData.put("code", (Object)"workflow.history");
            return this.fetchFormInternal(formData, sigma);
        }).compose(formData -> Ux.future((Object)response.mergeIn(formData)));
    }

    private Future<JsonObject> fetchFormInternal(JsonObject formData, String sigma) {
        JsonObject response = new JsonObject();
        JsonObject parameters = Wf.formInput(formData, sigma);
        return Ke.channel(Form.class, JsonObject::new, stub -> stub.fetchUi(parameters)).compose(Ux.attachJ((String)"form", (JsonObject)response));
    }
}

