/*
 * Decompiled with CFR 0.152.
 */
package cn.zeroup.macrocosm.service;

import cn.vertxup.workflow.domain.tables.daos.WTicketDao;
import cn.vertxup.workflow.domain.tables.daos.WTodoDao;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import cn.zeroup.macrocosm.service.AclStub;
import cn.zeroup.macrocosm.service.TaskStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.EngineOn;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.uca.component.HelperLinkage;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class TaskService
implements TaskStub {
    @Inject
    private transient AclStub aclStub;

    @Override
    public Future<JsonObject> fetchQueue(JsonObject condition) {
        JsonObject combine = Ux.whereQrA((JsonObject)condition, (String)"flowEnd", (Object)Boolean.FALSE);
        return Ux.Join.on().add(WTodoDao.class, "traceId").join(WTicketDao.class).alias(WTicketDao.class, new JsonObject().put("key", (Object)"traceKey").put("serial", (Object)"traceSerial").put("code", (Object)"traceCode")).searchAsync(combine);
    }

    @Override
    public Future<JsonObject> fetchHistory(JsonObject condition) {
        JsonObject combine = Ux.whereQrA((JsonObject)condition, (String)"flowEnd", (Object)Boolean.TRUE);
        return Ux.Jooq.on(WTicketDao.class).searchAsync(combine);
    }

    @Override
    public Future<JsonObject> readPending(String key, String userId) {
        WRecord record = new WRecord();
        return this.readTodo(key, record).compose(processed -> {
            WTodo todo = processed.todo();
            return Ux.future((Object)todo.getTraceId());
        }).compose(ticketId -> this.readTicket((String)ticketId, record)).compose(HelperLinkage::readLinkage).compose(this::readChild).compose(wData -> wData.futureJ(false)).compose(response -> this.aclStub.authorize(record, userId).compose(acl -> Ux.future((Object)response.put("acl", acl))));
    }

    private Future<WRecord> readTodo(String key, WRecord response) {
        return Ux.Jooq.on(WTodoDao.class).fetchByIdAsync((Object)key).compose(Ut.ifNil(response::bind, todo -> Ux.future((Object)response.bind((WTodo)todo))));
    }

    private Future<WRecord> readTicket(String key, WRecord response) {
        return Ux.Jooq.on(WTicketDao.class).fetchByIdAsync((Object)key).compose(Ut.ifNil(response::bind, ticket -> Ux.future((Object)response.bind((WTicket)ticket))));
    }

    private Future<WRecord> readChild(WRecord response) {
        WTicket ticket = response.ticket();
        Objects.requireNonNull(ticket);
        EngineOn engine = EngineOn.connect(ticket.getFlowDefinitionKey());
        MetaInstance meta = engine.metadata();
        UxJooq jq = meta.childDao();
        if (Objects.isNull(jq)) {
            return Ux.future((Object)response);
        }
        return jq.fetchJByIdAsync((Object)ticket.getKey()).compose(queried -> Ux.future((Object)response.child((JsonObject)queried)));
    }

    @Override
    public Future<JsonObject> readFinished(String key) {
        WRecord record = new WRecord();
        return this.readTicket(key, record).compose(HelperLinkage::readLinkage).compose(this::readChild).compose(wData -> wData.futureJ(true));
    }
}

