/*
 * Decompiled with CFR 0.152.
 */
package cn.zeroup.macrocosm.service;

import cn.vertxup.workflow.domain.tables.daos.WTodoDao;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import cn.zeroup.macrocosm.cv.em.TodoStatus;
import cn.zeroup.macrocosm.service.TodoStub;
import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.feature.Todo;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TodoService
implements TodoStub {
    @Override
    public Future<JsonObject> createTodo(String type, JsonObject data) {
        JsonObject defaultTodo = WfPin.getTodo(type);
        JsonObject inputData = data.copy();
        if (Objects.nonNull(defaultTodo)) {
            JsonObject params = data.copy();
            String name = Ut.fromExpression((String)defaultTodo.getString("name"), (JsonObject)params);
            String code = Ut.fromExpression((String)defaultTodo.getString("code"), (JsonObject)params);
            String url = Ut.fromExpression((String)defaultTodo.getString("todoUrl"), (JsonObject)params);
            inputData.mergeIn(defaultTodo);
            inputData.put("name", (Object)name);
            inputData.put("code", (Object)code);
            inputData.put("todoUrl", (Object)url);
        }
        WTodo todo = (WTodo)Ut.deserialize((JsonObject)inputData, WTodo.class);
        return Ux.Jooq.on(WTodoDao.class).insertAsync((Object)todo).compose(Ux::futureJ);
    }

    @Override
    public Future<JsonArray> fetchTodos(String sigma, String type, JsonArray statues) {
        JsonObject filters = new JsonObject();
        filters.put("sigma", (Object)sigma);
        if (Objects.nonNull(type)) {
            filters.put("type", (Object)type);
        }
        filters.put("status,i", (Object)statues);
        return Ux.Jooq.on(WTodoDao.class).fetchAndAsync(filters).compose(Ux::futureA);
    }

    @Override
    public Future<JsonArray> fetchTodos(String sigma, JsonArray types, JsonArray statues) {
        JsonObject filters = this.toFilters(sigma, types, statues);
        return Ux.Jooq.on(WTodoDao.class).fetchAndAsync(filters).compose(Ux::futureA);
    }

    @Override
    public Future<JsonArray> fetchTodos(String sigma, JsonArray types, JsonArray statues, JsonArray codes) {
        JsonObject filters = this.toFilters(sigma, types, statues);
        filters.put("code,i", (Object)codes);
        return Ux.Jooq.on(WTodoDao.class).fetchAndAsync(filters).compose(Ux::futureA);
    }

    private JsonObject toFilters(String sigma, JsonArray types, JsonArray statues) {
        JsonObject filters = new JsonObject();
        filters.put("sigma", (Object)sigma);
        if (Objects.nonNull(types)) {
            filters.put("type,i", (Object)types);
        }
        filters.put("status,i", (Object)statues);
        return filters;
    }

    @Override
    public Future<JsonArray> updateStatus(Set<String> keys, JsonObject params) {
        return Ux.Jooq.on(WTodoDao.class).fetchInAsync("key", Ut.toJArray(keys)).compose(Ux::futureA).compose(Ut.ifNil(JsonArray::new, todoArray -> {
            List todoList = Ut.deserialize((JsonArray)todoArray, (TypeReference)new TypeReference<List<WTodo>>(){});
            todoList = todoList.stream().map(todo -> this.combineTodo((WTodo)todo, params)).collect(Collectors.toList());
            return Ux.Jooq.on(WTodoDao.class).updateAsync(todoList).compose(Ux::futureA);
        }));
    }

    @Override
    public Future<JsonObject> updateStatus(String key, JsonObject params) {
        return Ux.Jooq.on(WTodoDao.class).fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(Ut.ifJNil(todoJson -> {
            WTodo todo = (WTodo)Ut.deserialize((JsonObject)todoJson, WTodo.class);
            todo = this.combineTodo(todo, params);
            return Ux.Jooq.on(WTodoDao.class).updateAsync((Object)todo).compose(Ux::futureJ);
        }));
    }

    private WTodo combineTodo(WTodo todo, JsonObject params) {
        if (Objects.isNull(todo)) {
            return null;
        }
        String userId = params.getString("userId");
        if (Ut.notNil((String)userId)) {
            todo.setUpdatedBy(userId);
            todo.setUpdatedAt(LocalDateTime.now());
            if (Objects.isNull(todo.getCreatedBy())) {
                todo.setCreatedBy(userId);
            }
        }
        if (params.containsKey("status")) {
            String status = params.getString("status");
            todo.setStatus(status);
            if (TodoStatus.FINISHED.name().equals(status)) {
                todo.setFinishedBy(todo.getUpdatedBy());
            }
        }
        return todo;
    }

    @Override
    public Future<JsonObject> fetchTodo(String key) {
        return Ux.Jooq.on(WTodoDao.class).fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(Ut.ifNil(JsonObject::new, todo -> Ke.channel(Todo.class, () -> todo, channel -> {
            Wf.Log.infoInit(this.getClass(), "Todo channel selected: {0}", channel.getClass().getName());
            JsonObject params = Ut.elementSubset((JsonObject)todo, (String[])new String[]{"modelId", "modelCategory", "modelKey", "sigma"});
            return channel.fetchAsync(key, params).compose(Ut.ifMerge((JsonObject)todo));
        })));
    }
}

