/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;

class ConfigTodo
implements Serializable {
    private final transient String identifier;
    private final transient String key;
    private final transient String indent;
    private final transient JsonObject todoData = new JsonObject();
    private transient Class<?> daoCls;

    public ConfigTodo(WRecord record) {
        Objects.requireNonNull(record);
        this.identifier = record.identifier();
        this.key = record.key();
        WTicket ticket = record.ticket();
        if (Objects.nonNull(ticket) && Objects.nonNull(ticket.getModelComponent())) {
            this.daoCls = Ut.clazz((String)ticket.getModelComponent(), null);
        }
        this.indent = null;
    }

    public ConfigTodo(JsonObject data) {
        JsonObject todo = data.getJsonObject("todo");
        Objects.requireNonNull(todo);
        this.indent = todo.getString("indent", null);
        if (todo.containsKey("modelComponent")) {
            this.daoCls = Ut.clazz((String)todo.getString("modelComponent"), null);
        }
        this.identifier = todo.getString("modelId", null);
        this.key = todo.getString("modelKey", null);
        this.todoData.mergeIn(todo, true);
    }

    public String identifier() {
        return this.identifier;
    }

    public String key() {
        return this.key;
    }

    public Class<?> dao() {
        return this.daoCls;
    }

    public String indent() {
        return this.indent;
    }

    public Future<JsonObject> initialize(JsonObject data) {
        return Ke.umIndent((JsonObject)data, (String)this.indent).compose(processed -> {
            JsonObject ticketData = processed.copy();
            Ut.ifJCopy((JsonObject)ticketData, (String)"indent", (String)"serial");
            Ut.ifJCopy((JsonObject)ticketData, (String)"indent", (String)"code");
            this.connecting(ticketData);
            JsonObject todo = this.todoData.copy();
            JsonObject combine = new JsonObject();
            Ut.itJObject((JsonObject)todo, (expression, field) -> {
                if (expression.contains("`")) {
                    combine.put(field, (Object)Ut.fromExpression((String)expression, (JsonObject)ticketData));
                } else {
                    combine.put(field, expression);
                }
            });
            ticketData.mergeIn(combine);
            JsonObject workflow = ticketData.getJsonObject("workflow", new JsonObject());
            ticketData.put("flowDefinitionKey", (Object)workflow.getString("definitionKey"));
            ticketData.put("flowDefinitionId", (Object)workflow.getString("definitionId"));
            return Ux.future((Object)ticketData);
        });
    }

    public void connecting(JsonObject todoData) {
        Object recordObj = todoData.getValue("record");
        if (Objects.nonNull(recordObj)) {
            if (recordObj instanceof JsonObject) {
                JsonObject record = (JsonObject)recordObj;
                todoData.put("modelKey", record.getValue("key"));
            } else if (recordObj instanceof JsonArray) {
                JsonArray records = (JsonArray)recordObj;
                JsonArray modelChild = new JsonArray();
                Ut.itJArray((JsonArray)records).forEach(json -> modelChild.add(json.getValue("key")));
                todoData.put("modelChild", (Object)modelChild.encode());
                todoData.put("quantity", (Object)modelChild.size());
            } else {
                Wf.Log.warnMove(this.getClass(), "`record` field type conflicts: {0}, type = {1}", recordObj, recordObj.getClass());
            }
        }
    }
}

