/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import cn.vertxup.workflow.domain.tables.pojos.WFlow;
import cn.zeroup.macrocosm.cv.WfPool;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WKey;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.uca.component.Behaviour;
import io.vertx.tp.workflow.uca.component.Movement;
import io.vertx.tp.workflow.uca.component.MovementEmpty;
import io.vertx.tp.workflow.uca.component.MovementPre;
import io.vertx.tp.workflow.uca.component.Stay;
import io.vertx.tp.workflow.uca.component.StayCancel;
import io.vertx.tp.workflow.uca.component.StaySave;
import io.vertx.tp.workflow.uca.component.Transfer;
import io.vertx.tp.workflow.uca.component.TransferEmpty;
import io.vertx.tp.workflow.uca.component.TransferStandard;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

public class EngineOn {
    private final transient WFlow workflow;
    private final transient MetaInstance metadata;

    private EngineOn(WFlow workflow) {
        Objects.requireNonNull(workflow);
        this.workflow = workflow;
        this.metadata = MetaInstance.input(Ut.toJObject((String)workflow.getStartConfig()), Ut.toJObject((String)workflow.getUiLinkage()));
    }

    public static EngineOn connect(String definitionKey) {
        Objects.requireNonNull(definitionKey);
        return (EngineOn)Fn.poolThread(WfPool.POOL_ENGINE, () -> {
            WFlow flow = WfPin.getFlow(definitionKey);
            return new EngineOn(flow);
        }, (String)definitionKey);
    }

    public static EngineOn connect(JsonObject params) {
        WKey key = WKey.build(params);
        return EngineOn.connect(key.definitionKey());
    }

    public Transfer componentStart() {
        return this.component(this.workflow::getStartComponent, this.workflow.getStartConfig(), () -> (Transfer)Ut.singleton(TransferEmpty.class, (Object[])new Object[0]));
    }

    public Transfer componentGenerate() {
        return this.component(this.workflow::getGenerateComponent, this.workflow.getGenerateConfig(), this::componentGenerateStandard);
    }

    public Movement componentRun() {
        return this.component(this.workflow::getRunComponent, this.workflow.getRunConfig(), () -> (Movement)Ut.singleton(MovementEmpty.class, (Object[])new Object[0]));
    }

    public Movement environmentPre() {
        return (Movement)this.component(MovementPre.class, null);
    }

    public Stay stayDraft() {
        return (Stay)this.component(StaySave.class, null);
    }

    public Stay stayCancel() {
        return (Stay)this.component(StayCancel.class, null);
    }

    private Transfer componentGenerateStandard() {
        return (Transfer)this.component(TransferStandard.class, this.workflow.getGenerateComponent());
    }

    private <C extends Behaviour> C component(Supplier<String> componentCls, String componentValue, Supplier<C> defaultCls) {
        Class clazz = Ut.clazz((String)componentCls.get(), null);
        if (Objects.isNull(clazz)) {
            return (C)((Behaviour)defaultCls.get());
        }
        return this.component(clazz, componentValue);
    }

    private <C extends Behaviour> C component(Class<?> clazz, String componentValue) {
        String keyComponent = this.metadata.recordComponentKey(clazz, componentValue);
        return (C)((Behaviour)Fn.poolThread(WfPool.POOL_COMPONENT, () -> {
            Behaviour instance = (Behaviour)Ut.instance((Class)clazz, (Object[])new Object[0]);
            instance.bind(Ut.toJObject((String)componentValue)).bind(this.metadata);
            return instance;
        }, (String)keyComponent));
    }

    public MetaInstance metadata() {
        Objects.requireNonNull(this.metadata);
        return this.metadata;
    }
}

