/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import cn.zeroup.macrocosm.cv.em.RecordMode;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.ConfigChild;
import io.vertx.tp.workflow.atom.ConfigLinkage;
import io.vertx.tp.workflow.atom.ConfigRecord;
import io.vertx.tp.workflow.atom.ConfigTodo;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.uca.modeling.Respect;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MetaInstance {
    private final transient ConfigRecord record;
    private final transient ConfigTodo todo;
    private final transient ConfigLinkage linkage;
    private final transient ConfigChild children;

    private MetaInstance(JsonObject startJson, JsonObject linkageJson) {
        JsonObject sure = Ut.valueJObject((JsonObject)startJson);
        this.record = (ConfigRecord)Ux.fromJson((JsonObject)sure.getJsonObject("record", new JsonObject()), ConfigRecord.class);
        this.children = (ConfigChild)Ux.fromJson((JsonObject)sure.getJsonObject("children", new JsonObject()), ConfigChild.class);
        this.linkage = new ConfigLinkage(linkageJson);
        this.todo = new ConfigTodo(sure);
    }

    private MetaInstance(WRecord record, MetaInstance input) {
        this.record = input.record;
        this.linkage = input.linkage;
        this.children = input.children;
        this.todo = new ConfigTodo(record);
    }

    public static MetaInstance input(JsonObject configJson, JsonObject linkageJson) {
        return new MetaInstance(configJson, linkageJson);
    }

    public static MetaInstance output(WRecord record, MetaInstance input) {
        return new MetaInstance(record, input);
    }

    public String recordComponentKey(Class<?> componentCls, String componentConfig) {
        Objects.requireNonNull(componentCls);
        StringBuilder componentKey = new StringBuilder();
        componentKey.append(componentCls.getName());
        componentKey.append(this.record.hashCode());
        if (Ut.notNil((String)componentConfig)) {
            componentKey.append(componentConfig.hashCode());
        }
        return componentKey.toString();
    }

    public RecordMode recordMode() {
        Objects.requireNonNull(this.record);
        return this.record.getMode();
    }

    public UxJooq recordDao() {
        Objects.requireNonNull(this.todo);
        return Ux.Jooq.on(this.todo.dao());
    }

    public String recordIndent() {
        Objects.requireNonNull(this.record);
        return this.record.getIndent();
    }

    public Boolean recordSkip() {
        return this.record.getVirtual();
    }

    public String recordKeyU(JsonObject recordData) {
        Objects.requireNonNull(this.record);
        String key = this.record.unique(recordData);
        Objects.requireNonNull(key);
        return key;
    }

    public Set<String> recordKeyU(JsonArray recordData) {
        Objects.requireNonNull(this.record);
        HashSet<String> keys = new HashSet<String>();
        Ut.itJArray((JsonArray)recordData).forEach(record -> keys.add(this.record.unique((JsonObject)record)));
        return keys;
    }

    public Set<String> linkFields() {
        Objects.requireNonNull(this.linkage);
        return this.linkage.fields();
    }

    public boolean linkSkip() {
        return Objects.isNull(this.linkage);
    }

    public Respect linkRespect(String field) {
        Objects.requireNonNull(this.linkage);
        return this.linkage.respect(field);
    }

    public Future<JsonObject> todoInitialize(JsonObject todoData) {
        return this.todo.initialize(todoData);
    }

    public UxJooq childDao() {
        if (Objects.isNull(this.children)) {
            return null;
        }
        if (Objects.isNull(this.children.getDao())) {
            return null;
        }
        return Ux.Jooq.on(this.children.getDao());
    }

    public JsonObject childData(JsonObject params) {
        JsonObject childData = new JsonObject();
        Set fields = Ut.toSet((JsonArray)this.children.getFields());
        fields.forEach(field -> childData.put(field, params.getValue(field)));
        return childData;
    }
}

