/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.WMoveRule;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WMove
implements Serializable {
    private final transient ConcurrentMap<String, WMoveRule> rules = new ConcurrentHashMap<String, WMoveRule>();
    private final transient JsonObject params = new JsonObject();
    private final transient String node;
    private final transient ConcurrentMap<String, String> data = new ConcurrentHashMap<String, String>();

    private WMove(String node, JsonObject config) {
        this.node = node;
        JsonObject data = Ut.valueJObject((JsonObject)config.getJsonObject("data"));
        Ut.itJObject((JsonObject)data, (value, field) -> this.data.put((String)field, (String)value));
        JsonArray rules = Ut.valueJArray((JsonArray)config.getJsonArray("rule"));
        Ut.itJArray((JsonArray)rules).forEach(json -> {
            WMoveRule rule = (WMoveRule)Ux.fromJson((JsonObject)json, WMoveRule.class);
            if (rule.valid()) {
                this.rules.put(rule.key(), rule);
            } else {
                Wf.Log.warnMove(this.getClass(), "Rule invalid: {0}", rule.toString());
            }
        });
    }

    public static WMove create(String node, JsonObject config) {
        return new WMove(node, config);
    }

    public static WMove empty() {
        return new WMove(null, new JsonObject());
    }

    public WMove stored(JsonObject request) {
        this.params.clear();
        this.data.forEach((to, from) -> this.params.put(to, request.getValue(from)));
        return this;
    }

    public WMoveRule ruleFind() {
        TreeSet keys = new TreeSet();
        this.params.fieldNames().forEach(field -> {
            Object value = this.params.getValue(field);
            if (Objects.nonNull(value)) {
                String key = field + "=" + value;
                keys.add(key);
            }
        });
        String key = Ut.fromJoin(keys);
        WMoveRule rule = this.rules.getOrDefault(key, null);
        Wf.Log.infoMove(this.getClass(), "[ Rule ] The node `{0}` rule processed: {1}", this.node, rule);
        return rule;
    }

    public JsonObject parameters() {
        return this.params;
    }
}

