/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import io.vertx.core.Future;
import io.vertx.tp.workflow.atom.WMove;
import io.vertx.tp.workflow.atom.WMoveRule;
import io.vertx.tp.workflow.uca.runner.EventOn;
import io.vertx.tp.workflow.uca.runner.IsOn;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class WProcess {
    private transient ProcessInstance instance;
    private transient Task task;
    private transient WMove move;

    private WProcess() {
    }

    public static WProcess create() {
        return new WProcess();
    }

    public WProcess bind(ProcessInstance instance) {
        this.instance = instance;
        return this;
    }

    public WProcess bind(Task task) {
        this.task = task;
        return this;
    }

    public WProcess bind(WMove move) {
        this.move = move;
        return this;
    }

    public Future<ProcessInstance> future(ProcessInstance instance) {
        this.instance = instance;
        if (Objects.isNull(this.task) && Objects.nonNull(instance)) {
            EventOn event = EventOn.get();
            return event.taskActive(instance).compose(task -> {
                this.task = task;
                return Ux.future((Object)instance);
            });
        }
        return Ux.future((Object)instance);
    }

    public Future<Task> future(Task task) {
        this.task = task;
        return Ux.future((Object)task);
    }

    public Future<WMove> future(WMove move) {
        this.move = move;
        return Ux.future((Object)move);
    }

    public Future<WProcess> future() {
        return Ux.future((Object)this);
    }

    public ProcessInstance instance() {
        return this.instance;
    }

    public Task task() {
        return this.task;
    }

    public WMoveRule rule() {
        return Objects.requireNonNull(this.move).ruleFind();
    }

    public boolean isEnd() {
        IsOn is = IsOn.get();
        return is.isEnd(this.instance);
    }

    public boolean isContinue() {
        return !this.isEnd();
    }

    public Future<Task> next() {
        EventOn event = EventOn.get();
        return event.taskActive(this.instance);
    }
}

