/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import cn.vertxup.workflow.domain.tables.daos.WTodoDao;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import cn.zeroup.macrocosm.cv.em.TodoStatus;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.EngineOn;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WProcessDefinition;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.modeling.ActionOn;
import io.vertx.tp.workflow.uca.runner.StoreOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WRecord
implements Serializable {
    private final transient ConcurrentMap<String, JsonArray> linkage = new ConcurrentHashMap<String, JsonArray>();
    private final transient JsonObject child = new JsonObject();
    private transient WTicket ticket;
    private transient WTodo todo;
    private transient TodoStatus status;
    private transient WProcessDefinition process;

    public WRecord bind() {
        this.todo = null;
        this.ticket = null;
        return this;
    }

    public WRecord bind(WTicket ticket) {
        this.ticket = ticket;
        return this;
    }

    public WRecord bind(WTodo todo) {
        this.todo = todo;
        return this;
    }

    public WRecord linkage(String field, JsonArray linkage) {
        JsonArray data = Ut.valueJArray((JsonArray)linkage);
        this.linkage.put(field, data);
        return this;
    }

    public WRecord child(JsonObject child) {
        if (Ut.notNil((JsonObject)child)) {
            this.child.mergeIn(child);
        }
        return this;
    }

    public WTodo todo() {
        return this.todo;
    }

    public WTicket ticket() {
        return this.ticket;
    }

    public String identifier() {
        return this.ticket.getModelId();
    }

    public String key() {
        return this.ticket.getModelKey();
    }

    public TodoStatus status() {
        return this.status;
    }

    public WRecord status(String literal) {
        this.status = (TodoStatus)Ut.toEnum(() -> literal, TodoStatus.class, null);
        return this;
    }

    public Future<JsonObject> futureJ() {
        return Ux.future((Object)this.data());
    }

    public Future<JsonObject> futureJ(boolean history) {
        String instanceId = this.ticket.getFlowInstanceId();
        JsonObject response = this.data();
        return Wf.instance(instanceId).compose(process -> {
            this.process = process;
            StoreOn storeOn = StoreOn.get();
            if (history) {
                return storeOn.workflowGet(process.definition(), process.instanceFinished());
            }
            return storeOn.workflowGet(process.definition(), process.instance());
        }).compose(workflow -> {
            EngineOn engine = EngineOn.connect(workflow.getString("definitionKey"));
            MetaInstance metadataInput = engine.metadata();
            ActionOn action = ActionOn.action(metadataInput.recordMode());
            MetaInstance metadataOutput = MetaInstance.output(this, metadataInput);
            if (metadataOutput.recordSkip().booleanValue()) {
                return Ux.future((Object)response);
            }
            String modelKey = this.ticket.getModelKey();
            if (Objects.isNull(modelKey)) {
                Set keys = Ut.toSet((JsonArray)Ut.toJArray((String)this.ticket.getModelChild()));
                return action.fetchAsync(keys, this.ticket.getModelId(), metadataOutput).compose(array -> {
                    response.put("record", array);
                    return Ux.future((Object)response);
                });
            }
            return action.fetchAsync(this.ticket.getModelKey(), this.ticket.getModelId(), metadataOutput).compose(json -> {
                response.put("record", json);
                return Ux.future((Object)response);
            });
        }).compose(processed -> {
            JsonObject criteria = Ux.whereAnd();
            criteria.put("traceId", (Object)this.ticket.getKey());
            if (!history && Objects.nonNull(this.todo)) {
                criteria.put("key,<>", (Object)this.todo.getKey());
            }
            criteria.put("status", (Object)new JsonArray().add((Object)TodoStatus.FINISHED.name()).add((Object)TodoStatus.REJECTED.name()).add((Object)TodoStatus.CANCELED.name()));
            return Ux.Jooq.on(WTodoDao.class).fetchAsync(criteria).compose(Ux::futureA);
        }).compose(Ux.attachJ((String)"history", (JsonObject)response)).compose(result -> {
            this.linkage.forEach((arg_0, arg_1) -> ((JsonObject)result).put(arg_0, arg_1));
            if (Ut.notNil((JsonObject)this.child)) {
                JsonObject childJ = this.child.copy();
                if (!result.containsKey("traceKey")) {
                    result.put("traceKey", childJ.getValue("key"));
                }
                childJ.remove("key");
                result.mergeIn(childJ);
            }
            return Ux.future((Object)result);
        });
    }

    public JsonObject data() {
        Objects.requireNonNull(this.ticket);
        JsonObject response = new JsonObject();
        JsonObject ticketJ = Ux.toJson((Object)this.ticket);
        Ut.ifJObject((JsonObject)ticketJ, (String[])new String[]{"modelChild"});
        ticketJ.put("traceKey", (Object)this.ticket.getKey());
        response.mergeIn(ticketJ, true);
        if (Objects.nonNull(this.todo)) {
            JsonObject todoJson = Ux.toJson((Object)this.todo);
            response.mergeIn(todoJson, true);
            response.put("taskCode", (Object)this.todo.getCode());
            response.put("taskSerial", (Object)this.todo.getSerial());
        }
        response.put("serial", (Object)this.ticket.getSerial());
        response.put("code", (Object)this.ticket.getCode());
        return response;
    }
}

