/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.init;

import cn.vertxup.workflow.domain.tables.daos.WFlowDao;
import cn.vertxup.workflow.domain.tables.pojos.WFlow;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.workflow.atom.MetaWorkflow;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.commune.config.Database;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.handler.DbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.jooq.Configuration;

final class WfConfiguration {
    private static final Node<JsonObject> READER = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final ConcurrentMap<String, WFlow> FLOW_POOL = new ConcurrentHashMap<String, WFlow>();
    private static MetaWorkflow CONFIG;
    private static ProcessEngine ENGINE;
    private static boolean ENABLED;
    private static HistoryEventHandler HANDLER;

    private WfConfiguration() {
    }

    static void init() {
        JsonObject configJson = (JsonObject)READER.read();
        if (configJson.containsKey("workflow")) {
            JsonObject configuration = configJson.getJsonObject("workflow", new JsonObject());
            Wf.Log.infoInit(WfConfiguration.class, "The workflow engine will be initialized!! `{0}`", configuration.encode());
            CONFIG = (MetaWorkflow)Ut.deserialize((JsonObject)configuration, MetaWorkflow.class);
            ENABLED = true;
        } else {
            ENABLED = false;
        }
    }

    static ProcessEngine camunda() {
        Objects.requireNonNull(CONFIG);
        if (Objects.isNull(ENGINE)) {
            Database database = CONFIG.camundaDatabase();
            Objects.requireNonNull(database);
            ProcessEngineConfigurationImpl configuration = new StandaloneProcessEngineConfiguration().setHistory(HistoryLevel.HISTORY_LEVEL_FULL.getName()).setHistoryEventHandler((HistoryEventHandler)new DbHistoryEventHandler()).setIdGenerator((IdGenerator)new StrongUuidGenerator()).setProcessEngineName(CONFIG.getName()).setDatabaseSchemaUpdate("false").setJdbcUrl(database.getJdbcUrl()).setJdbcDriver(database.getDriverClassName()).setJdbcUsername(database.getUsername()).setJdbcPassword(database.getPassword()).setJobExecutorActivate(true);
            HANDLER = configuration.getHistoryEventHandler();
            ENGINE = configuration.buildProcessEngine();
        }
        return ENGINE;
    }

    static List<String> camundaResources() {
        if (ENABLED) {
            List folders = Ut.ioDirectories((String)"workflow");
            ArrayList<String> results = new ArrayList<String>();
            folders.forEach(each -> results.add("workflow/" + each));
            Set<String> internal = CONFIG.camundaResource();
            if (!internal.isEmpty()) {
                internal.forEach(each -> results.add("workflow/" + each));
            }
            return results;
        }
        return new ArrayList<String>();
    }

    static Set<String> camundaBuiltIn() {
        if (Objects.isNull(CONFIG)) {
            WfConfiguration.init();
        }
        return CONFIG.camundaBuiltIn();
    }

    static HistoryEventHandler camundaLogger() {
        return HANDLER;
    }

    static Future<Boolean> init(Vertx vertx) {
        Configuration configuration = Ke.getConfiguration();
        WFlowDao flowDao = new WFlowDao(configuration, vertx);
        return ((Future)flowDao.findAll()).compose(flows -> {
            Wf.Log.infoInit(WfConfiguration.class, "Flow definitions: {0}", flows.size());
            FLOW_POOL.putAll(Ut.elementZip((Collection)flows, WFlow::getCode, flow -> flow));
            return Ux.futureT();
        });
    }

    static WFlow workflow(String code) {
        return (WFlow)FLOW_POOL.get(code);
    }
}

