/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.WProcessDefinition;
import io.vertx.tp.workflow.refine.WfFlow;
import io.vertx.tp.workflow.refine.WfLog;
import io.vertx.up.log.Annal;
import java.util.Objects;
import java.util.Set;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class Wf {
    public static JsonObject taskStart(JsonObject workflow, Set<StartEvent> starts) {
        return WfFlow.taskStart(workflow, starts);
    }

    public static JsonObject taskEnd(JsonObject workflow, Set<EndEvent> ends) {
        return WfFlow.taskEnd(workflow, ends);
    }

    public static JsonObject taskOut(JsonObject workflow, Task task) {
        return WfFlow.taskOut(workflow, task);
    }

    public static JsonObject formInput(JsonObject form, String sigma) {
        return WfFlow.formInput(form, sigma);
    }

    public static JsonObject formOut(String formKey, String definitionId, String definitionKey) {
        return WfFlow.formOut(formKey, definitionId, definitionKey);
    }

    public static JsonObject bpmnOut(ProcessDefinition definition) {
        return WfFlow.bpmnOut(definition);
    }

    public static Future<ProcessDefinition> processByKey(String definitionKey) {
        return WfFlow.processByKey(definitionKey);
    }

    public static Future<ProcessDefinition> processById(String definitionId) {
        return WfFlow.processById(definitionId);
    }

    public static Future<ProcessInstance> instanceById(String instanceId) {
        return WfFlow.instanceById(instanceId);
    }

    public static Future<WProcessDefinition> instance(String instanceId) {
        return WfFlow.instanceById(instanceId).compose(instance -> {
            if (Objects.isNull(instance)) {
                return WfFlow.instanceFinished(instanceId).compose(instanceFinished -> WfFlow.processById(instanceFinished.getProcessDefinitionId()).compose(definition -> WProcessDefinition.future(definition, instanceFinished)));
            }
            return WfFlow.processById(instance.getProcessDefinitionId()).compose(definition -> WProcessDefinition.future(definition, instance));
        });
    }

    public static class Log {
        public static void infoInit(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.info(logger, "Init", message, args);
        }

        public static void initQueue(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.info(logger, "Queue", message, args);
        }

        public static void debugInit(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.debug(logger, "Init", message, args);
        }

        public static void infoDeploy(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.info(logger, "Deploy", message, args);
        }

        public static void warnDeploy(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.warn(logger, "Deploy", message, args);
        }

        public static void warnMove(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.warn(logger, "Move", message, args);
        }

        public static void debugDeploy(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.debug(logger, "Deploy", message, args);
        }

        public static void infoMove(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.info(logger, "Move", message, args);
        }

        public static void infoWeb(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.info(logger, "Web", message, args);
        }

        public static void debugMove(Class<?> clazz, String message, Object ... args) {
            Annal logger = Annal.get(clazz);
            WfLog.debug(logger, "Move", message, args);
        }
    }
}

