/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404ProcessMissingException;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

class WfFlow {
    private static final ConcurrentMap<String, ProcessDefinition> POOL_PROCESS = new ConcurrentHashMap<String, ProcessDefinition>();

    WfFlow() {
    }

    static Future<ProcessDefinition> processByKey(String definitionKey) {
        Objects.requireNonNull(definitionKey);
        if (POOL_PROCESS.containsKey(definitionKey)) {
            return Ux.future((Object)((ProcessDefinition)POOL_PROCESS.get(definitionKey)));
        }
        RepositoryService service = WfPin.camundaRepository();
        ProcessDefinition definition = (ProcessDefinition)service.createProcessDefinitionQuery().latestVersion().processDefinitionKey(definitionKey).singleResult();
        if (Objects.nonNull(definition)) {
            POOL_PROCESS.put(definitionKey, definition);
        }
        return WfFlow.processInternal(definition, definitionKey);
    }

    static Future<ProcessDefinition> processById(String definitionId) {
        Objects.requireNonNull(definitionId);
        if (POOL_PROCESS.containsKey(definitionId)) {
            return Ux.future((Object)((ProcessDefinition)POOL_PROCESS.get(definitionId)));
        }
        RepositoryService service = WfPin.camundaRepository();
        ProcessDefinition definition = service.getProcessDefinition(definitionId);
        if (Objects.nonNull(definition)) {
            POOL_PROCESS.put(definitionId, definition);
        }
        return WfFlow.processInternal(definition, definitionId);
    }

    static Future<ProcessInstance> instanceById(String instanceId) {
        if (Objects.isNull(instanceId)) {
            return Ux.future();
        }
        RuntimeService service = WfPin.camundaRuntime();
        ProcessInstance instance = (ProcessInstance)service.createProcessInstanceQuery().processInstanceId(instanceId).singleResult();
        return Ux.future((Object)instance);
    }

    static Future<HistoricProcessInstance> instanceFinished(String instanceId) {
        if (Objects.isNull(instanceId)) {
            return Ux.future();
        }
        HistoryService service = WfPin.camundaHistory();
        HistoricProcessInstance instance = (HistoricProcessInstance)service.createHistoricProcessInstanceQuery().processInstanceId(instanceId).singleResult();
        return Ux.future((Object)instance);
    }

    private static Future<ProcessDefinition> processInternal(ProcessDefinition definition, String key) {
        if (Objects.isNull(definition)) {
            return Ux.thenError(_404ProcessMissingException.class, (Object[])new Object[]{WfFlow.class, key});
        }
        return Ux.future((Object)definition);
    }

    static JsonObject bpmnOut(ProcessDefinition definition) {
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(definition.getId());
        Objects.requireNonNull(instance);
        String xml = Bpmn.convertToString((BpmnModelInstance)instance);
        JsonObject workflow = new JsonObject();
        workflow.put("definitionId", (Object)definition.getId());
        workflow.put("definitionKey", (Object)definition.getKey());
        workflow.put("bpmn", (Object)xml);
        workflow.put("name", (Object)definition.getName());
        return workflow;
    }

    static JsonObject taskStart(JsonObject workflow, Set<StartEvent> starts) {
        if (1 == starts.size()) {
            StartEvent event = starts.iterator().next();
            workflow.put("task", (Object)event.getId());
            workflow.put("multiple", (Object)Boolean.FALSE);
        } else {
            JsonObject startMap = new JsonObject();
            starts.forEach(start -> startMap.put(start.getId(), (Object)start.getName()));
            workflow.put("task", (Object)startMap);
            workflow.put("multiple", (Object)Boolean.TRUE);
        }
        return workflow;
    }

    static JsonObject taskEnd(JsonObject workflow, Set<EndEvent> starts) {
        if (1 == starts.size()) {
            EndEvent event = starts.iterator().next();
            workflow.put("task", (Object)event.getId());
            workflow.put("multiple", (Object)Boolean.FALSE);
        } else {
            JsonObject startMap = new JsonObject();
            starts.forEach(start -> startMap.put(start.getId(), (Object)start.getName()));
            workflow.put("task", (Object)startMap);
            workflow.put("multiple", (Object)Boolean.TRUE);
        }
        return workflow;
    }

    static JsonObject taskOut(JsonObject workflow, Task task) {
        Objects.requireNonNull(task);
        workflow.put("multiple", (Object)Boolean.FALSE);
        workflow.put("task", (Object)task.getTaskDefinitionKey());
        return workflow;
    }

    static JsonObject formOut(String formKey, String definitionId, String definitionKey) {
        Objects.requireNonNull(formKey);
        String code = formKey.substring(formKey.lastIndexOf(":") + 1);
        JsonObject response = new JsonObject();
        response.put("code", (Object)code);
        response.put("formKey", (Object)formKey);
        response.put("definitionKey", (Object)definitionKey);
        response.put("definitionId", (Object)definitionId);
        return response;
    }

    static JsonObject formInput(JsonObject form, String sigma) {
        String definition = form.getString("definitionKey");
        JsonObject parameters = new JsonObject();
        String code = form.getString("code");
        String configFile = "workflow/" + definition + "/" + code + ".json";
        if (Ut.ioExist((String)configFile)) {
            parameters.put("dynamic", (Object)Boolean.FALSE);
            parameters.put("code", (Object)configFile);
        } else {
            parameters.put("dynamic", (Object)Boolean.TRUE);
            parameters.put("code", (Object)code);
            parameters.put("sigma", (Object)sigma);
        }
        return parameters;
    }
}

