/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.component;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WProcess;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.uca.component.AbstractTransfer;
import io.vertx.tp.workflow.uca.component.Behaviour;
import io.vertx.tp.workflow.uca.component.HelperLinkage;
import io.vertx.tp.workflow.uca.component.HelperTodo;
import java.util.Objects;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractMovement
extends AbstractTransfer {
    private transient HelperTodo todoKit;
    private transient HelperLinkage linkageKit;
    private transient MetaInstance metadata;

    @Override
    public Behaviour bind(MetaInstance metadata) {
        Objects.requireNonNull(metadata);
        this.metadata = metadata;
        this.todoKit = new HelperTodo(metadata);
        this.linkageKit = new HelperLinkage(metadata);
        return super.bind(metadata);
    }

    protected MetaInstance metadataIn() {
        return this.metadata;
    }

    protected Future<WRecord> insertAsync(JsonObject params, WProcess process) {
        ProcessInstance instance = process.instance();
        return this.todoKit.insertAsync(params, instance).compose(record -> this.linkageKit.syncAsync(params, (WRecord)record));
    }

    protected Future<WRecord> updateAsync(JsonObject params) {
        return this.todoKit.updateAsync(params).compose(record -> this.linkageKit.syncAsync(params, (WRecord)record));
    }

    protected Future<WRecord> saveAsync(JsonObject params, WProcess process) {
        ProcessInstance instance = process.instance();
        return this.todoKit.saveAsync(params, instance).compose(record -> this.linkageKit.syncAsync(params, (WRecord)record));
    }

    protected Future<WRecord> generateAsync(JsonObject params, WProcess instance, WRecord record) {
        WRecord generated = HelperTodo.nextJ(record, instance);
        return this.todoKit.generateAsync(params, generated);
    }
}

