/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.component;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WMove;
import io.vertx.tp.workflow.atom.WMoveRule;
import io.vertx.tp.workflow.uca.component.Behaviour;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractTransfer
implements Behaviour {
    protected final transient JsonObject config = new JsonObject();
    private final transient ConcurrentMap<String, WMove> moveMap = new ConcurrentHashMap<String, WMove>();

    @Override
    public Behaviour bind(JsonObject config) {
        JsonObject sure = Ut.valueJObject((JsonObject)config);
        this.config.mergeIn(sure.copy(), true);
        this.config.fieldNames().stream().filter(field -> !"record".equals(field)).filter(field -> !"todo".equals(field)).filter(field -> !"linkage".equals(field)).forEach(field -> {
            JsonObject value = this.config.getJsonObject(field);
            WMove item = WMove.create(field, value);
            this.moveMap.put((String)field, item);
        });
        return this;
    }

    @Override
    public Behaviour bind(MetaInstance metadata) {
        return this;
    }

    protected WMove moveGet(String node) {
        return this.moveMap.getOrDefault(node, WMove.empty());
    }

    protected Future<JsonObject> inputAsync(JsonObject params) {
        if (!params.containsKey("key")) {
            params.put("key", (Object)UUID.randomUUID().toString());
        }
        if (!params.containsKey("traceKey")) {
            params.put("traceKey", (Object)UUID.randomUUID().toString());
        }
        return Ux.future((Object)this.recordInput(params));
    }

    protected JsonObject recordInput(JsonObject params) {
        Object record = params.getValue("record");
        if (Objects.nonNull(record)) {
            if (record instanceof JsonObject) {
                JsonObject recordJ = (JsonObject)record;
                this.inputAsync(params, recordJ, true);
            } else if (record instanceof JsonArray) {
                JsonArray recordA = (JsonArray)record;
                JsonArray modelChild = new JsonArray();
                Ut.itJArray((JsonArray)recordA).map(json -> this.inputAsync(params, (JsonObject)json, false)).forEach(arg_0 -> ((JsonArray)modelChild).add(arg_0));
                params.put("modelChild", (Object)modelChild.encode());
            }
        }
        return params;
    }

    protected JsonObject recordMove(JsonObject request, WMoveRule rule) {
        Object recordData = request.getValue("record");
        if (Objects.isNull(recordData)) {
            return request;
        }
        if (recordData instanceof JsonObject) {
            JsonObject recordJ2 = (JsonObject)recordData;
            recordJ2.mergeIn(rule.getRecord());
            request.put("record", (Object)recordJ2);
        } else if (recordData instanceof JsonArray) {
            JsonArray recordA = (JsonArray)recordData;
            Ut.itJArray((JsonArray)recordA).forEach(recordJ -> recordJ.mergeIn(rule.getRecord()));
            request.put("record", (Object)recordA);
        }
        return request;
    }

    private String inputAsync(JsonObject params, JsonObject record, boolean o2o) {
        String recordKey;
        if (record.containsKey("key")) {
            recordKey = record.getString("key");
        } else {
            recordKey = UUID.randomUUID().toString();
            record.put("key", (Object)recordKey);
        }
        if (o2o) {
            params.put("modelKey", (Object)recordKey);
        }
        record.put("modelKey", params.getValue("traceKey"));
        return recordKey;
    }
}

