/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.component;

import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.EngineOn;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.modeling.Respect;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HelperLinkage {
    private final transient MetaInstance metadata;

    HelperLinkage(MetaInstance metadata) {
        this.metadata = metadata;
    }

    private HelperLinkage(WRecord record) {
        WTicket ticket = record.ticket();
        Objects.requireNonNull(ticket);
        EngineOn engine = EngineOn.connect(ticket.getFlowDefinitionKey());
        this.metadata = engine.metadata();
    }

    public static Future<WRecord> readLinkage(WRecord record) {
        HelperLinkage helper = new HelperLinkage(record);
        return helper.fetchAsync(record);
    }

    private Future<WRecord> fetchAsync(WRecord record) {
        if (this.metadata.linkSkip()) {
            return Ux.future((Object)record);
        }
        ConcurrentHashMap futures = new ConcurrentHashMap();
        Set<String> fields = this.metadata.linkFields();
        Wf.Log.infoWeb(this.getClass(), "( Fetch ) Linkage Definition Size: {0}", fields.size());
        fields.forEach(field -> {
            Respect respect = this.metadata.linkRespect((String)field);
            futures.put(field, respect.fetchAsync(record));
        });
        return Ux.thenCombine(futures).compose(dataMap -> {
            dataMap.forEach(record::linkage);
            return Ux.future((Object)record);
        });
    }

    Future<WRecord> syncAsync(JsonObject params, WRecord record) {
        WTicket ticket = record.ticket();
        if (Objects.isNull(ticket) || this.metadata.linkSkip()) {
            return Ux.future((Object)record);
        }
        ConcurrentHashMap futures = new ConcurrentHashMap();
        Set<String> fields = this.metadata.linkFields();
        Wf.Log.infoWeb(this.getClass(), "( Sync ) Linkage Definition Size: {0}", fields.size());
        fields.forEach(field -> {
            JsonArray linkageData = Ut.valueJArray((JsonObject)params, (String)field);
            if (Ut.notNil((JsonArray)linkageData)) {
                Respect respect = this.metadata.linkRespect((String)field);
                futures.put(field, respect.syncAsync(linkageData, params, record));
            }
        });
        return Ux.thenCombine(futures).compose(dataMap -> {
            dataMap.forEach(record::linkage);
            return Ux.future((Object)record);
        });
    }
}

