/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.component;

import cn.vertxup.workflow.domain.tables.daos.WTicketDao;
import cn.vertxup.workflow.domain.tables.daos.WTodoDao;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import cn.zeroup.macrocosm.cv.em.TodoStatus;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WMoveRule;
import io.vertx.tp.workflow.atom.WProcess;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.uca.runner.EventOn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

class HelperTodo {
    private final transient MetaInstance metadata;

    HelperTodo(MetaInstance metadata) {
        this.metadata = metadata;
    }

    static JsonObject closeJ(JsonObject params, WProcess wProcess) {
        WMoveRule rule;
        JsonObject updatedData = params.copy();
        updatedData.put("status", (Object)TodoStatus.FINISHED.name());
        String user = params.getString("updatedBy");
        updatedData.put("finishedAt", (Object)Instant.now());
        updatedData.put("finishedBy", (Object)user);
        updatedData.put("active", (Object)Boolean.TRUE);
        updatedData.put("closeAt", (Object)Instant.now());
        updatedData.put("closeBy", (Object)user);
        if (wProcess.isEnd()) {
            updatedData.put("flowEnd", (Object)Boolean.TRUE);
        }
        if (Objects.nonNull(rule = wProcess.rule()) && Ut.notNil((JsonObject)rule.getTodo())) {
            updatedData.mergeIn(rule.getTodo());
        }
        return updatedData;
    }

    static JsonObject cancelJ(JsonObject params, WProcess wProcess, Set<String> historySet) {
        JsonObject todoData = params.copy();
        String user = todoData.getString("updatedBy");
        HashSet<String> traceSet = new HashSet<String>(historySet);
        Task task = wProcess.task();
        if (Objects.nonNull(task)) {
            traceSet.add(task.getTaskDefinitionKey());
        }
        JsonObject history = new JsonObject();
        history.put("history", (Object)Ut.toJArray(traceSet));
        todoData.put("status", (Object)TodoStatus.CANCELED.name());
        todoData.put("finishedAt", (Object)Instant.now());
        todoData.put("finishedBy", (Object)user);
        todoData.put("flowEnd", (Object)Boolean.TRUE);
        todoData.put("cancelAt", (Object)Instant.now());
        todoData.put("cancelBy", (Object)user);
        todoData.put("closeAt", (Object)Instant.now());
        todoData.put("closeBy", (Object)user);
        return todoData;
    }

    static WRecord nextJ(WRecord record, WProcess wProcess) {
        JsonObject newJson = record.data();
        WTodo todo = record.todo();
        WTicket ticket = record.ticket();
        WTodo entity = (WTodo)Ux.fromJson((JsonObject)newJson, WTodo.class);
        entity.setKey(UUID.randomUUID().toString());
        entity.setTraceOrder(todo.getTraceOrder() + 1);
        entity.setSerial(ticket.getSerial() + "-" + Ut.fromAdjust((Integer)entity.getTraceOrder(), (Integer)2));
        entity.setCode(entity.getSerial());
        entity.setCommentApproval(null);
        entity.setCommentReject(null);
        Task nextTask = wProcess.task();
        entity.setTraceId(ticket.getKey());
        entity.setTaskId(nextTask.getId());
        entity.setTaskKey(nextTask.getTaskDefinitionKey());
        entity.setStatus(TodoStatus.PENDING.name());
        entity.setFinishedAt(null);
        entity.setFinishedBy(null);
        entity.setCreatedAt(LocalDateTime.now());
        entity.setCreatedBy(todo.getCreatedBy());
        entity.setUpdatedAt(LocalDateTime.now());
        entity.setUpdatedBy(todo.getUpdatedBy());
        WMoveRule rule = wProcess.rule();
        if (Objects.nonNull(rule)) {
            JsonObject todoUpdate = rule.getTodo();
            entity = (WTodo)Ux.updateT((Object)entity, (JsonObject)todoUpdate);
        }
        return new WRecord().bind(ticket).bind(entity);
    }

    Future<WRecord> saveAsync(JsonObject params, ProcessInstance instance) {
        JsonObject ticketJson = params.copy();
        String tKey = ticketJson.getString("traceId");
        UxJooq tJq = Ux.Jooq.on(WTicketDao.class);
        return tJq.fetchByIdAsync((Object)tKey).compose(ticket -> {
            if (Objects.isNull(ticket)) {
                return this.insertAsync(params, instance);
            }
            return this.updateTicket(params, (WTicket)ticket).compose(updated -> this.updateTodo(params, new WRecord().bind((WTicket)updated)));
        });
    }

    Future<WRecord> generateAsync(JsonObject params, WRecord record) {
        return Ux.Jooq.on(WTicketDao.class).updateAsync((Object)record.ticket()).compose(ticket -> Ux.Jooq.on(WTodoDao.class).insertAsync((Object)record.todo()).compose(nil -> Ux.future((Object)record)));
    }

    Future<WRecord> insertAsync(JsonObject params, ProcessInstance instance) {
        return this.metadata.todoInitialize(params).compose(normalized -> {
            String todoKey = normalized.getString("key");
            normalized.remove("key");
            WTicket ticket = (WTicket)Ux.fromJson((JsonObject)normalized, WTicket.class);
            ticket.setKey(normalized.getString("traceKey"));
            ticket.setFlowEnd(Boolean.FALSE);
            ticket.setFlowInstanceId(instance.getId());
            return Ux.Jooq.on(WTicketDao.class).insertAsync((Object)ticket).compose(inserted -> this.updateChild((JsonObject)normalized, (WTicket)inserted)).compose(inserted -> {
                WTodo todo = (WTodo)Ux.fromJson((JsonObject)normalized, WTodo.class);
                todo.setKey(todoKey);
                todo.setTraceId(inserted.getKey());
                todo.setTraceOrder(1);
                todo.setCode(inserted.getCode() + "-" + Ut.fromAdjust((Integer)todo.getTraceOrder(), (Integer)2));
                todo.setSerial(inserted.getSerial() + "-" + Ut.fromAdjust((Integer)todo.getTraceOrder(), (Integer)2));
                EventOn event = EventOn.get();
                return event.taskActive(instance).compose(task -> {
                    todo.setTaskId(task.getId());
                    todo.setTaskKey(task.getTaskDefinitionKey());
                    return Ux.future((Object)todo);
                }).compose(arg_0 -> ((UxJooq)Ux.Jooq.on(WTodoDao.class)).insertAsync(arg_0)).compose(insertedTodo -> {
                    WRecord record = new WRecord();
                    record.bind((WTicket)inserted).bind((WTodo)insertedTodo);
                    return Ux.future((Object)record);
                });
            });
        });
    }

    Future<WRecord> updateAsync(JsonObject params) {
        String tKey = params.getString("traceId");
        return Ux.Jooq.on(WTicketDao.class).fetchByIdAsync((Object)tKey).compose(ticket -> this.updateTicket(params, (WTicket)ticket)).compose(ticket -> this.updateChild(params, (WTicket)ticket)).compose(ticket -> this.updateTodo(params, new WRecord().bind((WTicket)ticket)));
    }

    private Future<WRecord> updateTodo(JsonObject params, WRecord recordRef) {
        UxJooq tJq = Ux.Jooq.on(WTodoDao.class);
        String key = params.getString("key");
        return tJq.fetchByIdAsync((Object)key).compose(query -> {
            recordRef.status(query.getStatus());
            JsonObject todoJ = params.copy();
            todoJ.remove("key");
            todoJ.remove("serial");
            todoJ.remove("code");
            WTodo updated = (WTodo)Ux.updateT((Object)query, (JsonObject)todoJ);
            return tJq.updateAsync((Object)updated).compose(todo -> {
                recordRef.bind((WTodo)todo);
                return Ux.future((Object)recordRef);
            });
        });
    }

    private Future<WTicket> updateTicket(JsonObject params, WTicket ticket) {
        UxJooq tJq = Ux.Jooq.on(WTicketDao.class);
        JsonObject ticketJ = params.copy();
        ticketJ.remove("key");
        ticketJ.remove("serial");
        ticketJ.remove("code");
        WTicket updated = (WTicket)Ux.updateT((Object)ticket, (JsonObject)ticketJ);
        return tJq.updateAsync((Object)updated);
    }

    private Future<WTicket> updateChild(JsonObject params, WTicket ticket) {
        UxJooq tJq = this.metadata.childDao();
        if (Objects.isNull(tJq)) {
            return Ux.future((Object)ticket);
        }
        JsonObject data = this.metadata.childData(params);
        data.put("key", (Object)ticket.getKey());
        return tJq.upsertJAsync((Object)ticket.getKey(), data).compose(child -> Ux.future((Object)ticket));
    }
}

