/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.component;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.WKey;
import io.vertx.tp.workflow.atom.WMove;
import io.vertx.tp.workflow.atom.WProcess;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.component.AbstractTransfer;
import io.vertx.tp.workflow.uca.component.Movement;
import io.vertx.tp.workflow.uca.runner.EventOn;
import io.vertx.tp.workflow.uca.runner.RunOn;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class MovementNext
extends AbstractTransfer
implements Movement {
    @Override
    public Future<WProcess> moveAsync(JsonObject params) {
        WKey key = WKey.build(params);
        String instanceId = key.instanceId();
        EventOn eventOn = EventOn.get();
        WProcess wProcess = WProcess.create();
        return Wf.instanceById(instanceId).compose(wProcess::future).compose(instance -> {
            if (Objects.isNull(instance)) {
                String definitionId = key.definitionId();
                return eventOn.start(definitionId).compose(event -> Ux.future((Object)this.moveGet(event.getId())));
            }
            String taskId = key.taskId();
            return eventOn.taskSmart((ProcessInstance)instance, taskId).compose(wProcess::future).compose(task -> Ux.future((Object)this.moveGet(task.getTaskDefinitionKey())));
        }).compose(move -> {
            wProcess.bind(move.stored(params));
            ProcessInstance instance = wProcess.instance();
            RunOn runOn = RunOn.get();
            if (Objects.isNull(instance)) {
                String definitionKey = key.definitionKey();
                return runOn.startAsync(definitionKey, (WMove)move).compose(wProcess::future).compose(nil -> wProcess.future());
            }
            return runOn.moveAsync(instance, (WMove)move).compose(nil -> wProcess.future());
        });
    }
}

