/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.component;

import cn.zeroup.macrocosm.cv.em.TodoStatus;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.MetaInstance;
import io.vertx.tp.workflow.atom.WMove;
import io.vertx.tp.workflow.atom.WMoveRule;
import io.vertx.tp.workflow.atom.WProcess;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.uca.component.AbstractMovement;
import io.vertx.tp.workflow.uca.component.HelperTodo;
import io.vertx.tp.workflow.uca.component.Transfer;
import io.vertx.tp.workflow.uca.modeling.Register;
import io.vertx.tp.workflow.uca.runner.IsOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.task.Task;

public class TransferStandard
extends AbstractMovement
implements Transfer {
    @Override
    public Future<WRecord> moveAsync(JsonObject params, WProcess wProcess) {
        return this.inputAsync(params).compose(normalized -> {
            JsonObject todoData = HelperTodo.closeJ(normalized, wProcess);
            return this.saveAsync(todoData, wProcess).compose(this.saveAsyncFn((JsonObject)normalized, wProcess));
        }).compose(record -> wProcess.next().compose(taskNext -> {
            IsOn is = IsOn.get();
            if (wProcess.isContinue() && is.isUserEvent((Task)taskNext)) {
                WProcess instanceNext = WProcess.create();
                Task task = wProcess.task();
                WMove move = this.moveGet(task.getTaskDefinitionKey());
                move.stored(params);
                instanceNext.bind((Task)taskNext).bind(move).bind(wProcess.instance());
                return this.generateAsync(params, instanceNext, (WRecord)record);
            }
            return Ux.future((Object)record);
        }));
    }

    private Function<WRecord, Future<WRecord>> saveAsyncFn(JsonObject input, WProcess process) {
        return record -> {
            WMoveRule moveRule;
            TodoStatus status = record.status();
            JsonObject request = input.copy();
            request.mergeIn(record.data());
            MetaInstance metadataOut = MetaInstance.output(record, this.metadataIn());
            if (TodoStatus.PENDING == status && Objects.nonNull(moveRule = process.rule()) && Ut.notNil((JsonObject)moveRule.getRecord())) {
                request = this.recordMove(request, moveRule);
            }
            Register register = Register.instance(request);
            return register.saveAsync(request, metadataOut).compose(nil -> Ux.future((Object)record));
        };
    }
}

