/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.deployment;

import io.vertx.core.Future;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.plugin.FlowSequenceListener;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.deployment.DeployFormService;
import io.vertx.tp.workflow.uca.deployment.DeployOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

class DeployBpmnService
implements DeployOn {
    private final transient DeploymentBuilder builder;
    private final transient DeployOn formStub;
    private transient String tenantId;

    DeployBpmnService(String workflow) {
        RepositoryService repository = WfPin.camundaRepository();
        this.builder = repository.createDeployment();
        this.builder.name(workflow);
        this.builder.source("zero.framework");
        this.builder.enableDuplicateFiltering(Boolean.TRUE.booleanValue());
        List files = Ut.ioFiles((String)workflow);
        String bpmnFile = files.stream().filter(item -> item.endsWith(".bpmn")).findAny().orElse(null);
        Objects.requireNonNull(bpmnFile);
        String modelFile = workflow + "/" + bpmnFile;
        Wf.Log.infoDeploy(this.getClass(), "Load BPMN model from `{0}`", modelFile);
        BpmnModelInstance instance = Bpmn.readModelFromStream((InputStream)Ut.ioStream((String)modelFile));
        Objects.requireNonNull(instance);
        this.initializeListener(instance);
        this.builder.addModelInstance(bpmnFile, instance);
        Set<String> forms = files.stream().filter(item -> item.endsWith(".form")).collect(Collectors.toSet());
        this.formStub = new DeployFormService(workflow, this.builder).forms(forms);
    }

    private void initializeListener(BpmnModelInstance instance) {
        Collection sequences = instance.getModelElementsByType(SequenceFlow.class);
        sequences.forEach(sequence -> {
            ExtensionElements elements = (ExtensionElements)instance.newInstance(ExtensionElements.class);
            CamundaExecutionListener elementListener = (CamundaExecutionListener)instance.newInstance(CamundaExecutionListener.class);
            elementListener.setCamundaClass(FlowSequenceListener.class.getName());
            elements.addChildElement((ModelElementInstance)elementListener);
            sequence.setExtensionElements(elements);
        });
    }

    @Override
    public Future<Boolean> initialize() {
        Objects.requireNonNull(this.builder);
        if (Ut.notNil((String)this.tenantId)) {
            this.builder.tenantId(this.tenantId);
        }
        return this.formStub.initialize().compose(nil -> {
            DeploymentWithDefinitions deployment = this.builder.deployWithResult();
            Wf.Log.infoDeploy(this.getClass(), "Workflow `{0}\uff08id = {1}\uff09` has been deployed successfully!", deployment.getName(), deployment.getId());
            return Ux.futureT();
        });
    }

    @Override
    public DeployOn tenant(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }
}

