/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.deployment;

import io.vertx.core.Future;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.deployment.DeployOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.camunda.bpm.engine.repository.DeploymentBuilder;

class DeployFormService
implements DeployOn {
    private final transient DeploymentBuilder builderRef;
    private final transient Set<String> formFiles = new HashSet<String>();
    private final transient String workflow;

    DeployFormService(String workflow, DeploymentBuilder builder) {
        this.builderRef = builder;
        this.workflow = workflow;
    }

    public DeployOn forms(Set<String> formFiles) {
        if (Objects.nonNull(formFiles)) {
            this.formFiles.addAll(formFiles);
        }
        return this;
    }

    @Override
    public Future<Boolean> initialize() {
        Objects.requireNonNull(this.builderRef);
        if (this.formFiles.isEmpty()) {
            return Ux.futureT();
        }
        this.formFiles.forEach(formFile -> {
            String filePath = this.workflow + "/" + formFile;
            InputStream istream = Ut.ioStream((String)filePath);
            if (Objects.nonNull(istream)) {
                this.builderRef.addInputStream(formFile, istream);
            } else {
                Wf.Log.warnDeploy(this.getClass(), "Ignored: `{0}` does not exist.", filePath);
            }
        });
        return Ux.futureT();
    }
}

