/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.modeling;

import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.feature.Linkage;
import io.vertx.tp.workflow.atom.WRecord;
import io.vertx.tp.workflow.uca.modeling.AbstractRespect;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

public class RespectLink
extends AbstractRespect {
    public RespectLink(JsonObject query) {
        super(query);
    }

    @Override
    public Future<JsonArray> syncAsync(JsonArray data, JsonObject params, WRecord record) {
        JsonArray dataArray = this.syncPre(data, params, record);
        WTicket ticket = record.ticket();
        JsonObject condition = this.queryTpl();
        condition.put("sourceKey", (Object)ticket.getKey());
        JsonArray keys = Ut.valueJArray((JsonArray)dataArray, (String)"key");
        condition.put("key,!i", (Object)keys);
        return Ke.channelAsync(Linkage.class, Ux::futureA, link -> link.unlink(condition).compose(deleted -> link.link(dataArray, false)));
    }

    @Override
    protected void syncPre(JsonObject data, JsonObject params, WRecord record) {
        WTicket ticket = record.ticket();
        JsonObject sourceData = Ux.toJson((Object)ticket);
        data.put("sourceKey", (Object)ticket.getKey());
        data.put("sourceData", (Object)sourceData);
        JsonObject parameters = new JsonObject();
        parameters.mergeIn(Ut.fromPrefix((JsonObject)sourceData, (String)"source"));
        JsonObject targetData = data.getJsonObject("targetData");
        parameters.mergeIn(Ut.fromPrefix((JsonObject)targetData, (String)"target"));
        Ut.fromExpression((JsonObject)data, (JsonObject)parameters);
    }

    @Override
    public Future<JsonArray> fetchAsync(WRecord record) {
        WTicket ticket = record.ticket();
        JsonObject condition = this.queryTpl();
        condition.put("sourceKey", (Object)ticket.getKey());
        return Ke.channelAsync(Linkage.class, Ux::futureA, link -> link.fetch(condition));
    }
}

