/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.runner;

import io.vertx.core.Future;
import io.vertx.tp.error._409UniqueStartEventException;
import io.vertx.tp.error._501ProcessStartException;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.up.unity.Ux;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

class KitEvent {
    KitEvent() {
    }

    String type(String definitionId, String taskKey) {
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(definitionId);
        ModelElementInstance node = instance.getModelElementById(taskKey);
        return node.getElementType().getTypeName();
    }

    Future<Set<StartEvent>> startSet(String definitionId) {
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(definitionId);
        Collection starts = instance.getModelElementsByType(StartEvent.class);
        if (starts.isEmpty()) {
            return Ux.thenError(_501ProcessStartException.class, (Object[])new Object[]{this.getClass(), definitionId});
        }
        return Ux.future(new HashSet(starts));
    }

    Future<Set<EndEvent>> endSet(String definitionId) {
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(definitionId);
        Collection starts = instance.getModelElementsByType(EndEvent.class);
        return Ux.future(new HashSet(starts));
    }

    Future<EndEvent> end(String definitionId) {
        return this.endSet(definitionId).compose(set -> {
            if (set.isEmpty()) {
                return Ux.future();
            }
            return Ux.future((Object)((EndEvent)set.iterator().next()));
        });
    }

    Future<StartEvent> start(String definitionId) {
        return this.startSet(definitionId).compose(set -> {
            int size = set.size();
            if (1 == size) {
                return Ux.future((Object)((StartEvent)set.iterator().next()));
            }
            return Ux.thenError(_409UniqueStartEventException.class, (Object[])new Object[]{this.getClass(), size, definitionId});
        });
    }
}

