/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.runner;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.WMove;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.runner.RunOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;

class RunEngine
implements RunOn {
    RunEngine() {
    }

    @Override
    public Future<ProcessInstance> moveAsync(ProcessInstance instance, WMove move) {
        Objects.requireNonNull(instance);
        TaskService service = WfPin.camundaTask();
        Task task = (Task)service.createTaskQuery().active().processInstanceId(instance.getId()).singleResult();
        Objects.requireNonNull(task);
        JsonObject params = move.parameters();
        service.complete(task.getId(), params.getMap());
        Wf.Log.infoMove(this.getClass(), "[ Move ] Ended = {0}, `instance = {1}` moving with params = {2} !!!", instance.isEnded(), instance.getId(), params.encode());
        return Ux.future((Object)instance);
    }

    @Override
    public Future<ProcessInstance> startAsync(String definitionKey, WMove move) {
        RuntimeService service = WfPin.camundaRuntime();
        ProcessInstantiationBuilder builder = service.createProcessInstanceByKey(definitionKey);
        JsonObject params = move.parameters();
        if (Ut.notNil((JsonObject)params)) {
            builder.setVariables(params.getMap());
        }
        ProcessInstance instance = builder.execute();
        Wf.Log.infoMove(this.getClass(), "[ Start ] `instance = {0}` has been started with params = {1}!!!", instance.getId(), params.encode());
        return Ux.future((Object)instance);
    }

    @Override
    public Future<Boolean> stopAsync(ProcessInstance instance) {
        RuntimeService service = WfPin.camundaRuntime();
        return null;
    }
}

