/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.runner;

import cn.zeroup.macrocosm.cv.em.TodoStatus;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.runner.EventOn;
import io.vertx.tp.workflow.uca.runner.StoreOn;
import io.vertx.up.atom.Refer;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

class StoreEngine
implements StoreOn {
    StoreEngine() {
    }

    @Override
    public Future<JsonObject> workflowGet(ProcessDefinition definition) {
        JsonObject workflow = Wf.bpmnOut(definition);
        EventOn eventOn = EventOn.get();
        return eventOn.startSet(definition.getId()).compose(starts -> Ux.future((Object)Wf.taskStart(workflow, starts)));
    }

    @Override
    public Future<JsonObject> workflowGet(ProcessDefinition definition, HistoricProcessInstance instance) {
        JsonObject workflow = Wf.bpmnOut(definition);
        EventOn eventOn = EventOn.get();
        return eventOn.endSet(definition.getId()).compose(ends -> Ux.future((Object)Wf.taskEnd(workflow, ends))).compose(response -> eventOn.taskHistory(instance).compose(history -> {
            response.put("history", (Object)Ut.toJArray((Set)history));
            return Ux.future((Object)response);
        }));
    }

    @Override
    public Future<JsonObject> workflowGet(ProcessDefinition definition, ProcessInstance instance) {
        JsonObject workflow = Wf.bpmnOut(definition);
        EventOn eventOn = EventOn.get();
        Refer responseRef = new Refer();
        Refer taskRef = new Refer();
        return eventOn.taskActive(instance).compose(arg_0 -> ((Refer)taskRef).future(arg_0)).compose(task -> Ux.future((Object)Wf.taskOut(workflow, task))).compose(arg_0 -> ((Refer)responseRef).future(arg_0)).compose(nil -> eventOn.taskHistory(instance)).compose(history -> {
            Task task = (Task)taskRef.get();
            history.remove(task.getTaskDefinitionKey());
            JsonArray historyA = Ut.toJArray((Set)history);
            JsonObject response = (JsonObject)responseRef.get();
            return Ux.future((Object)response.put("history", (Object)historyA));
        });
    }

    @Override
    public Future<JsonObject> formGet(ProcessDefinition definition) {
        FormService formService = WfPin.camundaForm();
        StartFormData startForm = formService.getStartFormData(definition.getId());
        Objects.requireNonNull(startForm);
        String formKey = startForm.getFormKey();
        return Ux.future((Object)Wf.formOut(formKey, definition.getId(), definition.getKey()));
    }

    @Override
    public Future<JsonObject> formGet(ProcessDefinition definition, ProcessInstance instance) {
        EventOn eventOn = EventOn.get();
        return eventOn.taskActive(instance).compose(task -> {
            String formKey = task.getFormKey();
            return Ux.future((Object)Wf.formOut(formKey, definition.getId(), definition.getKey()));
        });
    }

    @Override
    public Future<Boolean> instanceEnd(ProcessInstance instance) {
        RuntimeService service = WfPin.camundaRuntime();
        service.deleteProcessInstanceIfExists(instance.getId(), TodoStatus.CANCELED.name(), false, false, false, false);
        return Ux.futureT();
    }
}

