/*
 * Decompiled with CFR 0.152.
 */
package cn.vinsonws.tools.geoserver.connector.body;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;

public interface WithBody {
    public HttpRequest.BodyPublisher getBodyPublisher();

    public void validate();

    public static interface Empty
    extends WithBody {
        @Override
        default public HttpRequest.BodyPublisher getBodyPublisher() {
            return HttpRequest.BodyPublishers.noBody();
        }
    }

    public static class JsonBody
    implements Json {
        private final Object o;

        protected JsonBody(Object o) {
            this.o = o;
        }

        @Override
        public Object getRequestBody() {
            return this.o;
        }

        @Override
        public void validate() {
        }
    }

    public static interface Json
    extends WithBody {
        @Override
        default public HttpRequest.BodyPublisher getBodyPublisher() {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(this.getRequestBody()), StandardCharsets.UTF_8);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public Object getRequestBody();
    }
}

