/*
 * Decompiled with CFR 0.152.
 */
package cn.vinsonws.tools.geoserver.connector.caller;

import cn.vinsonws.tools.geoserver.connector.AsyncGeoserverClient;
import cn.vinsonws.tools.geoserver.connector.RestConstant;
import cn.vinsonws.tools.geoserver.connector.body.WithBodies;
import cn.vinsonws.tools.geoserver.connector.body.WithBody;
import cn.vinsonws.tools.geoserver.connector.caller.CommonCaller;
import cn.vinsonws.tools.geoserver.connector.exception.GeoserverServiceFailedRuntimeException;
import cn.vinsonws.tools.geoserver.connector.util.HttpUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public abstract class AbstractCaller {
    private String api;
    private RestConstant.Method method = RestConstant.Method.GET;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public void addParameter(String name, String value) {
        this.parameters.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
    }

    public void addHeader(String name, String value) {
        this.headers.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setMethod(RestConstant.Method method) {
        this.method = method;
    }

    public RestConstant.Method getMethod() {
        return this.method;
    }

    public String getApiWithParameters() {
        String parameter = this.getParameterString();
        if (parameter.length() > 0) {
            return this.api + "?" + parameter;
        }
        return this.api;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameterString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            sb.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '&') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String toString() {
        return "AbstractArgs{api='" + this.api + "', method=" + this.method + ", parameters=" + this.parameters + ", headers=" + this.headers + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCaller that = (AbstractCaller)o;
        if (!Objects.equals(this.api, that.api)) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.headers.equals(that.headers);
    }

    public int hashCode() {
        int result = this.api != null ? this.api.hashCode() : 0;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.headers.hashCode();
        return result;
    }

    public static interface Delete
    extends Executable<CommonCaller> {
        default public CommonCaller buildDeleteArgs() {
            return (CommonCaller)this.build(RestConstant.Method.DELETE);
        }

        default public void remove() {
            this.DELETE();
        }

        default public void DELETE() {
            try {
                ((CompletableFuture)this.client().executeAsync(this.buildDeleteArgs(), null).thenAccept(response -> {
                    if (!HttpUtils.validateResponse(response)) {
                        throw new GeoserverServiceFailedRuntimeException(response.statusCode(), response.uri().toString(), (String)response.body());
                    }
                })).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GeoserverServiceFailedRuntimeException) {
                    throw (GeoserverServiceFailedRuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Put
    extends Executable<CommonCaller> {
        default public CommonCaller buildPutArgs() {
            return (CommonCaller)this.build(RestConstant.Method.PUT);
        }

        default public void PUT(WithBody withBody) {
            try {
                ((CompletableFuture)this.client().executeAsync(this.buildPutArgs(), withBody).thenAccept(response -> {
                    if (!HttpUtils.validateResponse(response)) {
                        throw new GeoserverServiceFailedRuntimeException(response.statusCode(), response.uri().toString(), (String)response.body());
                    }
                })).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GeoserverServiceFailedRuntimeException) {
                    throw (GeoserverServiceFailedRuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        default public void update() {
            this.PUT(WithBodies.EMPTY);
        }

        default public void update(WithBody withBody) {
            this.PUT(withBody);
        }
    }

    public static interface Post
    extends Executable<CommonCaller> {
        default public CommonCaller buildPostArgs() {
            return (CommonCaller)this.build(RestConstant.Method.POST);
        }

        default public void POST(WithBody withBody) {
            try {
                ((CompletableFuture)this.client().executeAsync(this.buildPostArgs(), withBody).thenAccept(response -> {
                    if (!HttpUtils.validateResponse(response)) {
                        throw new GeoserverServiceFailedRuntimeException(response.statusCode(), response.uri().toString(), (String)response.body());
                    }
                })).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GeoserverServiceFailedRuntimeException) {
                    throw (GeoserverServiceFailedRuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        default public void create() {
            this.POST(WithBodies.EMPTY);
        }

        default public void create(WithBody withBody) {
            this.POST(withBody);
        }
    }

    public static interface Get<R>
    extends Executable<CommonCaller> {
        default public CommonCaller buildGetArgs() {
            return (CommonCaller)this.build(RestConstant.Method.GET);
        }

        default public R fetch() {
            return this.GET();
        }

        default public R GET() {
            try {
                return (R)((CompletableFuture)this.client().executeAsync(this.buildGetArgs(), null).thenApply(response -> {
                    if (!HttpUtils.validateResponse(response)) {
                        throw new GeoserverServiceFailedRuntimeException(response.statusCode(), response.uri().toString(), (String)response.body());
                    }
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        return mapper.readValue((String)response.body(), new TypeReference<R>(){});
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                })).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GeoserverServiceFailedRuntimeException) {
                    throw (GeoserverServiceFailedRuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }

    static interface Executable<A extends AbstractCaller> {
        public A build(RestConstant.Method var1);

        public AsyncGeoserverClient client();
    }

    public static class ExecutableBuilder<B extends Builder<B, CommonCaller>>
    extends Builder<B, CommonCaller>
    implements Executable<CommonCaller> {
        private final AsyncGeoserverClient client;

        protected ExecutableBuilder(AsyncGeoserverClient client, String apiFormatter) {
            super(apiFormatter);
            this.client = client;
        }

        protected ExecutableBuilder(ExecutableBuilder<?> other) {
            super(other);
            this.client = other.client;
        }

        @Override
        public AsyncGeoserverClient client() {
            return this.client;
        }

        @Override
        protected CommonCaller newInstance() {
            return new CommonCaller();
        }
    }

    public static abstract class Builder<B extends Builder<B, A>, A extends AbstractCaller> {
        private String apiFormatter;
        private final Map<String, String> parameters = new HashMap<String, String>();
        private final Map<String, String> headers = new HashMap<String, String>();

        public Builder(String apiFormatter) {
            this.apiFormatter = apiFormatter;
        }

        public Builder(Builder<?, ?> other) {
            this.parameters.putAll(other.parameters);
            this.headers.putAll(other.headers);
            this.apiFormatter = other.apiFormatter;
        }

        public B parameter(String name, String value) {
            this.parameters.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
            return (B)this;
        }

        public B appendApi(String v) {
            this.apiFormatter = this.apiFormatter + v;
            return (B)this;
        }

        public B header(String name, String value) {
            this.headers.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
            return (B)this;
        }

        public A build(RestConstant.Method method) {
            A args = this.buildCaller();
            ((AbstractCaller)args).setMethod(method);
            return args;
        }

        public A buildCaller() {
            A args = this.newInstance();
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                ((AbstractCaller)args).addParameter(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                ((AbstractCaller)args).addHeader(entry.getKey(), entry.getValue());
            }
            ((AbstractCaller)args).setApi(this.apiFormatter);
            return args;
        }

        protected abstract A newInstance();

        public String toString() {
            StringBuilder sb = new StringBuilder("Builder{");
            sb.append("api='").append(this.apiFormatter).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

