/*
 * Decompiled with CFR 0.152.
 */
package cn.vinsonws.tools.geoserver.connector;

import cn.vinsonws.tools.geoserver.connector.AsyncGeoserverClient;
import cn.vinsonws.tools.geoserver.connector.caller.Base;
import cn.vinsonws.tools.geoserver.connector.caller.Fonts;
import cn.vinsonws.tools.geoserver.connector.caller.Logging;
import cn.vinsonws.tools.geoserver.connector.caller.Manifest;
import cn.vinsonws.tools.geoserver.connector.caller.Namespace;
import cn.vinsonws.tools.geoserver.connector.caller.Reload;
import cn.vinsonws.tools.geoserver.connector.caller.ResetCache;
import cn.vinsonws.tools.geoserver.connector.caller.Resource;
import cn.vinsonws.tools.geoserver.connector.caller.Status;
import cn.vinsonws.tools.geoserver.connector.caller.SystemStatus;
import cn.vinsonws.tools.geoserver.connector.caller.Version;
import cn.vinsonws.tools.geoserver.connector.caller.Workspace;
import cn.vinsonws.tools.geoserver.connector.caller.gwc.GeoWebCache;
import cn.vinsonws.tools.geoserver.connector.caller.gwc.MapService;
import java.util.Base64;
import java.util.Map;

public class GeoserverConnector {
    private final AsyncGeoserverClient asyncClient;
    private final Base.BaseBuilder base;

    public GeoserverConnector(String baseurl, String userName, String password) {
        this.asyncClient = new AsyncGeoserverClient(baseurl, "Basic " + Base64.getEncoder().encodeToString((userName + ":" + password).getBytes()));
        this.base = Base.base(this.asyncClient);
    }

    public Manifest.ManifestBuilder aboutManifest() {
        return this.base.aboutManifest();
    }

    public SystemStatus.SystemStatusBuilder aboutSystemStatus() {
        return this.base.aboutSystemStatus();
    }

    public Status.Builder aboutStatus() {
        return this.base.aboutStatus();
    }

    public Version.Builder aboutVersion() {
        return this.base.aboutVersion();
    }

    public ResetCache.ResetCacheBuilder resetCache() {
        return this.base.resetCache();
    }

    public Reload.ReloadBuilder reload() {
        return this.base.reload();
    }

    public Fonts.FontsBuilder fonts() {
        return this.base.fonts();
    }

    public Logging.LoggingBuilder logging() {
        return this.base.logging();
    }

    public Resource.ResourcesBuilder resources() {
        return this.base.resources();
    }

    public Workspace.WorkspacesBuilder workspaces() {
        return this.base.workspaces();
    }

    public Namespace.NamespacesBuilder namespaces() {
        return this.base.namespaces();
    }

    public GeoWebCache.GeoWebCacheBuilder gwc() {
        return this.base.gwc();
    }

    public static void main(String[] args) {
        GeoserverConnector connector = new GeoserverConnector("http://192.168.1.32:28080/geoserver/", "admin", "geoserver");
        MapService.TMSBuilder tms = connector.gwc().service().tms("geo-adapter-default:chengdu", "EPSG:4326", "png");
        System.out.println(tms.url());
        System.out.println(((Map)tms.fetch()).get("BoundingBox"));
        MapService.WMTSBuilder wmts = connector.gwc().service().wmts("geo-adapter-default:chengdu", "EPSG:4326", "image/png");
        System.out.println(wmts.url());
    }
}

