/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.page;

import cn.vonce.sql.bean.Order;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.enumerate.SqlSort;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

public class PageHelper<T>
implements Serializable {
    public static final String SELECT = "select";
    public static final String COUNT = "count";
    private Integer pagenum;
    private Integer pagesize;
    private boolean startByZero;
    private Integer totalRecords;
    private Integer totalPage;
    private Order[] orders;
    private String timestamp;
    private List<T> dataList;
    private PagingMethod pagingMethod;

    public PageHelper() {
    }

    public PageHelper(Integer pagenum, Integer pagesize) {
        this(pagenum, pagesize, null, null);
    }

    public PageHelper(Integer pagenum, Integer pagesize, String timestamp) {
        this(pagenum, pagesize, null, timestamp);
    }

    public PageHelper(Integer pagenum, Integer pagesize, boolean startByZero, String timestamp) {
        this(pagenum, pagesize, startByZero, null, timestamp);
    }

    public PageHelper(Integer pagenum, Integer pagesize, Order[] orders, String timestamp) {
        this.init(pagenum, pagesize, false, orders, timestamp);
    }

    public PageHelper(Integer pagenum, Integer pagesize, boolean startByZero, Order[] orders, String timestamp) {
        this.init(pagenum, pagesize, startByZero, orders, timestamp);
    }

    public void init(Integer pagenum, Integer pagesize, boolean startByZero, Order[] orders, String timestamp) {
        if (this.pagenum == null) {
            this.pagenum = pagenum == null ? (startByZero ? 1 : 0) : pagenum;
        }
        if (this.pagesize == null) {
            this.pagesize = pagesize == null ? 10 : pagesize;
        }
        if (this.orders == null) {
            this.orders = orders;
        }
        if (this.timestamp == null) {
            this.setTimestamp(timestamp);
        }
        this.startByZero = startByZero;
    }

    public Integer getPagenum() {
        return this.pagenum;
    }

    public Integer getPagesize() {
        return this.pagesize;
    }

    public boolean getStartByZero() {
        return this.startByZero;
    }

    public Integer getTotalRecords() {
        return this.totalRecords;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    private void setTimestamp(String timestamp) {
        boolean convertSuccess = true;
        try {
            if (StringUtil.isNotEmpty(timestamp)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                format.setLenient(false);
                format.parse(timestamp);
            } else {
                convertSuccess = false;
            }
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        if (convertSuccess) {
            this.timestamp = timestamp;
        }
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public PagingMethod getPagingMethod() {
        if (this.pagingMethod == null) {
            this.pagingMethod = new PagingMethod(COUNT, SELECT);
        }
        return this.pagingMethod;
    }

    public void setPagingMethod(PagingMethod pagingMethod) {
        this.pagingMethod = pagingMethod;
    }

    public void dispose(int count) {
        this.totalRecords = count;
        this.totalPage = this.totalRecords % this.pagesize == 0 ? this.totalRecords / this.pagesize : this.totalRecords / this.pagesize + 1;
    }

    public PageHelper<T> paging(Select select, PagingService pageService) {
        return this.paging(null, select, pageService);
    }

    public PageHelper<T> paging(Class<T> returnType, Select select, PagingService pageService) {
        try {
            Class<?> clazz = pageService.getClass();
            Select countSelect = SqlBeanUtil.copy(select);
            ReflectUtil.instance().invoke(Select.class, countSelect, COUNT, true);
            select.page(this.pagenum, this.pagesize, this.startByZero);
            select.orderBy(this.orders);
            Class[] paramClasses = new Class[]{Select.class};
            Object[] countParams = new Object[]{countSelect};
            Object[] listParams = new Object[]{select};
            if (returnType != null) {
                paramClasses = new Class[]{Class.class, Select.class};
                countParams = new Object[]{returnType, countSelect};
                listParams = new Object[]{returnType, select};
            }
            this.dispose((Integer)ReflectUtil.instance().invoke(clazz, pageService, this.getPagingMethod().getCount(), paramClasses, countParams));
            this.setDataList((List)ReflectUtil.instance().invoke(clazz, pageService, this.getPagingMethod().getSelect(), paramClasses, listParams));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Order[] getOrder(String[] sortdatafields, String[] sortorders) {
        Order[] orders = null;
        if (sortdatafields != null && sortdatafields.length > 0) {
            orders = new Order[sortdatafields.length];
            for (int i = 0; i < sortdatafields.length; ++i) {
                Order order = null;
                String field = sortdatafields[i];
                String sort = null;
                try {
                    sort = sortorders[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtil.isNotEmpty(field) && field.indexOf(".") > -1) {
                    String[] tableNameAndField = field.split("\\.");
                    order = new Order(tableNameAndField[0], tableNameAndField[1], SqlSort.get(sort));
                } else {
                    order = new Order(field, SqlSort.get(sort));
                }
                orders[i] = order;
            }
        }
        return orders;
    }

    public ResultData<T> getResultData() {
        ResultData<T> resultData = new ResultData<T>();
        resultData.setData(this.getDataList());
        resultData.setPagenum(this.getPagenum());
        resultData.setPagesize(this.getPagesize());
        resultData.setTotalRecords(this.getTotalRecords());
        resultData.setTotalPage(this.getTotalPage());
        resultData.setTimestamp(this.getTimestamp());
        return resultData;
    }

    public Paging getPaging() {
        return new Paging(this.pagenum, this.pagesize, this.getStartByZero(), this.orders);
    }

    public static class PagingMethod {
        private String count;
        private String select;

        public PagingMethod() {
        }

        public PagingMethod(String count, String select) {
            this.count = count;
            this.select = select;
        }

        public String getCount() {
            return this.count;
        }

        public void setCount(String count) {
            this.count = count;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }
    }
}

