/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import cn.vonce.sql.uitls.Ulid;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Random;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;

public final class UlidFactory {
    private final Clock clock;
    private final LongFunction<Ulid> ulidFunction;

    public UlidFactory() {
        this(new UlidFunction(IRandom.newInstance()));
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction) {
        this(ulidFunction, null);
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction, Clock clock) {
        this.ulidFunction = ulidFunction;
        this.clock = clock != null ? clock : Clock.systemUTC();
    }

    public static UlidFactory newInstance() {
        return new UlidFactory(new UlidFunction(IRandom.newInstance()));
    }

    public static UlidFactory newInstance(Random random) {
        return new UlidFactory(new UlidFunction(IRandom.newInstance(random)));
    }

    public static UlidFactory newInstance(LongSupplier randomFunction) {
        return new UlidFactory(new UlidFunction(IRandom.newInstance(randomFunction)));
    }

    public static UlidFactory newInstance(IntFunction<byte[]> randomFunction) {
        return new UlidFactory(new UlidFunction(IRandom.newInstance(randomFunction)));
    }

    public static UlidFactory newMonotonicInstance() {
        return new UlidFactory(new MonotonicFunction(IRandom.newInstance()));
    }

    public static UlidFactory newMonotonicInstance(Random random) {
        return new UlidFactory(new MonotonicFunction(IRandom.newInstance(random)));
    }

    public static UlidFactory newMonotonicInstance(LongSupplier randomFunction) {
        return new UlidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)));
    }

    public static UlidFactory newMonotonicInstance(IntFunction<byte[]> randomFunction) {
        return new UlidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)));
    }

    static UlidFactory newMonotonicInstance(LongSupplier randomFunction, Clock clock) {
        return new UlidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)), clock);
    }

    static UlidFactory newMonotonicInstance(IntFunction<byte[]> randomFunction, Clock clock) {
        return new UlidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)), clock);
    }

    public synchronized Ulid create() {
        return this.ulidFunction.apply(this.clock.millis());
    }

    public synchronized Ulid create(long time) {
        return this.ulidFunction.apply(time);
    }

    static final class UlidFunction
    implements LongFunction<Ulid> {
        private final IRandom random;

        public UlidFunction(IRandom random) {
            this.random = random;
        }

        @Override
        public Ulid apply(long time) {
            if (this.random instanceof ByteRandom) {
                return new Ulid(time, this.random.nextBytes(10));
            }
            long msb = time << 16 | this.random.nextLong() & 0xFFFFL;
            long lsb = this.random.nextLong();
            return new Ulid(msb, lsb);
        }
    }

    static interface IRandom {
        public long nextLong();

        public byte[] nextBytes(int var1);

        public static IRandom newInstance() {
            return new ByteRandom();
        }

        public static IRandom newInstance(Random random) {
            if (random == null) {
                return new ByteRandom();
            }
            if (random instanceof SecureRandom) {
                return new ByteRandom(random);
            }
            return new LongRandom(random);
        }

        public static IRandom newInstance(LongSupplier randomFunction) {
            return new LongRandom(randomFunction);
        }

        public static IRandom newInstance(IntFunction<byte[]> randomFunction) {
            return new ByteRandom(randomFunction);
        }
    }

    static final class MonotonicFunction
    implements LongFunction<Ulid> {
        private Ulid lastUlid;
        private final IRandom random;
        protected static final int CLOCK_DRIFT_TOLERANCE = 10000;

        public MonotonicFunction(IRandom random) {
            this.random = random;
            this.lastUlid = new Ulid(0L, this.random.nextBytes(10));
        }

        @Override
        public synchronized Ulid apply(long time) {
            long lastTime = this.lastUlid.getTime();
            if (time > lastTime - 10000L && time <= lastTime) {
                this.lastUlid = this.lastUlid.increment();
            } else if (this.random instanceof ByteRandom) {
                this.lastUlid = new Ulid(time, this.random.nextBytes(10));
            } else {
                long msb = time << 16 | this.random.nextLong() & 0xFFFFL;
                long lsb = this.random.nextLong();
                this.lastUlid = new Ulid(msb, lsb);
            }
            return new Ulid(this.lastUlid);
        }
    }

    static class ByteRandom
    implements IRandom {
        private final IntFunction<byte[]> randomFunction;

        public ByteRandom() {
            this(ByteRandom.newRandomFunction(null));
        }

        public ByteRandom(Random random) {
            this(ByteRandom.newRandomFunction(random));
        }

        public ByteRandom(IntFunction<byte[]> randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : ByteRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            long number = 0L;
            byte[] bytes = this.randomFunction.apply(8);
            for (int i = 0; i < 8; ++i) {
                number = number << 8 | (long)(bytes[i] & 0xFF);
            }
            return number;
        }

        @Override
        public byte[] nextBytes(int length) {
            return this.randomFunction.apply(length);
        }

        static IntFunction<byte[]> newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
    }

    static class LongRandom
    implements IRandom {
        private final LongSupplier randomFunction;

        public LongRandom() {
            this(LongRandom.newRandomFunction(null));
        }

        public LongRandom(Random random) {
            this(LongRandom.newRandomFunction(random));
        }

        public LongRandom(LongSupplier randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : LongRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            return this.randomFunction.getAsLong();
        }

        @Override
        public byte[] nextBytes(int length) {
            int shift = 0;
            long random = 0L;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (shift < 8) {
                    shift = 64;
                    random = this.randomFunction.getAsLong();
                }
                bytes[i] = (byte)(random >>> (shift -= 8));
            }
            return bytes;
        }

        static LongSupplier newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return entropy::nextLong;
        }
    }
}

