/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.android.mapper;

import android.database.Cursor;
import cn.vonce.sql.android.mapper.RowMapper;
import cn.vonce.sql.annotation.SqlJSON;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.json.JSONConvert;
import cn.vonce.sql.mapper.BaseMapper;
import cn.vonce.sql.mapper.ResultSetDelegate;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SqlBeanMapper<T>
extends BaseMapper<Cursor>
implements RowMapper<T> {
    public Class<?> clazz;
    public Class<?> returnType;

    public SqlBeanMapper(Class<?> clazz, Class<?> returnType) {
        this.clazz = clazz;
        this.returnType = returnType;
    }

    @Override
    public List<String> getColumnNameList(ResultSetDelegate<Cursor> resultSetDelegate) {
        Cursor cursor = resultSetDelegate.getDelegate();
        return Arrays.asList(cursor.getColumnNames());
    }

    @Override
    public T mapRow(ResultSetDelegate<Cursor> resultSetDelegate, int index) {
        T object = null;
        if (resultSetDelegate.getDelegate().moveToNext()) {
            if (this.returnType.getName().equals(ColumnInfo.class.getName()) || this.returnType.getName().equals(TableInfo.class.getName())) {
                return (T)this.beanHandleResultSet(this.returnType, resultSetDelegate, this.getColumnNameList(resultSetDelegate));
            }
            if (SqlBeanUtil.isBaseType(this.returnType)) {
                return (T)this.baseHandleResultSet(resultSetDelegate);
            }
            if (SqlBeanUtil.isMap(this.returnType)) {
                return (T)this.mapHandleResultSet(resultSetDelegate);
            }
            return (T)this.beanHandleResultSet(this.returnType, resultSetDelegate, this.getColumnNameList(resultSetDelegate));
        }
        return object;
    }

    @Override
    public Object baseHandleResultSet(ResultSetDelegate<Cursor> resultSetDelegate) {
        Cursor cursor = resultSetDelegate.getDelegate();
        Object value = this.getValue(cursor.getType(0), 0, cursor);
        if (value != null && !value.getClass().getName().equals(this.returnType.getName())) {
            value = SqlBeanUtil.getValueConvert(this.returnType, value);
        }
        if (value == null || value.equals("null")) {
            value = this.getDefaultValueByColumnType(cursor.getType(0));
        }
        return value;
    }

    @Override
    public Object mapHandleResultSet(ResultSetDelegate<Cursor> resultSetDelegate) {
        Cursor cursor = resultSetDelegate.getDelegate();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i < cursor.getColumnCount(); ++i) {
            Object value = this.getValue(cursor.getType(i), i, cursor);
            if (value == null || value.equals("null")) {
                value = this.getDefaultValueByColumnType(cursor.getType(i));
            }
            map.put(cursor.getColumnName(i), value);
        }
        return map;
    }

    @Override
    public Object getValue(Field field, String columnName, ResultSetDelegate<Cursor> resultSetDelegate) {
        Cursor cursor = resultSetDelegate.getDelegate();
        Object value = null;
        int index = cursor.getColumnIndex(columnName);
        if (index == -1) {
            return null;
        }
        try {
            SqlJSON sqlJSON = field.getAnnotation(SqlJSON.class);
            if (sqlJSON != null && sqlJSON.convert() != JSONConvert.class) {
                String json = cursor.getString(index);
                return SqlBeanUtil.convertJSON(sqlJSON.convert().newInstance(), json, field);
            }
            switch (field.getType().getName()) {
                case "byte": 
                case "java.lang.Byte": {
                    value = Byte.parseByte(cursor.getShort(index) + "");
                    break;
                }
                case "short": 
                case "java.lang.Short": {
                    value = cursor.getShort(index);
                    break;
                }
                case "int": 
                case "java.lang.Integer": {
                    value = cursor.getInt(index);
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    value = Float.valueOf(cursor.getFloat(index));
                    break;
                }
                case "double": 
                case "java.lang.Double": {
                    value = cursor.getDouble(index);
                    break;
                }
                case "long": 
                case "java.lang.Long": {
                    value = cursor.getLong(index);
                    break;
                }
                case "boolean": 
                case "java.lang.Boolean": {
                    short bool = cursor.getShort(index);
                    if (bool > 0) {
                        value = true;
                        break;
                    }
                    value = false;
                    break;
                }
                case "char": 
                case "java.lang.Character": {
                    value = cursor.getString(index);
                    if (StringUtil.isNotEmpty(value)) {
                        value = Character.valueOf(value.toString().charAt(0));
                    }
                    break;
                }
                case "java.lang.String": {
                    value = cursor.getString(index);
                    break;
                }
                case "java.sql.Date": 
                case "java.sql.Time": 
                case "java.sql.Timestamp": 
                case "java.util.Date": {
                    long timestamp = cursor.getLong(index);
                    String stringTimestamp = timestamp + "";
                    if (stringTimestamp.length() == 10 || stringTimestamp.length() == 13) {
                        value = new Date(timestamp);
                        break;
                    }
                    value = DateUtil.stringToDate(cursor.getString(index));
                    break;
                }
                case "java.math.BigDecimal": {
                    value = new BigDecimal(cursor.getDouble(index));
                    break;
                }
                default: {
                    value = cursor.getBlob(index);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Object getValue(String jdbcType, int index, ResultSetDelegate<Cursor> resultSetDelegate) {
        return null;
    }

    public Object getValue(int jdbcType, int index, Cursor cursor) {
        Object value = null;
        switch (jdbcType) {
            case 1: {
                value = cursor.getLong(index);
                break;
            }
            case 2: {
                value = cursor.getDouble(index);
                break;
            }
            case 3: {
                value = cursor.getString(index);
                break;
            }
            case 4: {
                value = cursor.getBlob(index);
            }
        }
        return value;
    }

    public Object getDefaultValueByColumnType(int jdbcType) {
        Number value = null;
        switch (jdbcType) {
            case 1: {
                value = 0;
                break;
            }
            case 2: {
                value = Float.valueOf(0.0f);
                break;
            }
            case 3: 
            case 4: {
                value = null;
            }
        }
        return value;
    }
}

