/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.enumerate;

import cn.vonce.sql.dialect.DB2Dialect;
import cn.vonce.sql.dialect.DerbyDialect;
import cn.vonce.sql.dialect.H2Dialect;
import cn.vonce.sql.dialect.HsqlDialect;
import cn.vonce.sql.dialect.MysqlDialect;
import cn.vonce.sql.dialect.OracleDialect;
import cn.vonce.sql.dialect.PostgresqlDialect;
import cn.vonce.sql.dialect.SqlDialect;
import cn.vonce.sql.dialect.SqlServerDialect;
import cn.vonce.sql.dialect.SqliteDialect;
import cn.vonce.sql.uitls.StringUtil;

public enum DbType {
    MySQL(new MysqlDialect()),
    MariaDB(new MysqlDialect()),
    SQLServer(new SqlServerDialect()),
    Oracle(new OracleDialect()),
    Postgresql(new PostgresqlDialect()),
    DB2(new DB2Dialect()),
    H2(new H2Dialect()),
    Hsql(new HsqlDialect()),
    Derby(new DerbyDialect()),
    SQLite(new SqliteDialect());

    private SqlDialect sqlDialect;

    private DbType(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public static DbType getDbType(String productName) {
        if (StringUtil.isNotEmpty(productName)) {
            if ((productName = productName.replace(" ", "").toLowerCase()).indexOf(MySQL.name().toLowerCase()) >= 0) {
                return MySQL;
            }
            if (productName.indexOf(MariaDB.name().toLowerCase()) >= 0) {
                return MariaDB;
            }
            if (productName.indexOf(Oracle.name().toLowerCase()) >= 0) {
                return Oracle;
            }
            if (productName.indexOf(SQLServer.name().toLowerCase()) >= 0) {
                return SQLServer;
            }
            if (productName.indexOf(Postgresql.name().toLowerCase()) >= 0) {
                return Postgresql;
            }
            if (productName.indexOf(DB2.name().toLowerCase()) >= 0) {
                return DB2;
            }
            if (productName.indexOf(Derby.name().toLowerCase()) >= 0) {
                return Derby;
            }
            if (productName.indexOf(SQLite.name().toLowerCase()) >= 0) {
                return SQLite;
            }
            if (productName.indexOf(Hsql.name().toLowerCase()) >= 0) {
                return Hsql;
            }
            if (productName.indexOf(H2.name().toLowerCase()) >= 0) {
                return H2;
            }
        }
        return null;
    }
}

