package cn.vonce.sql.json;

import cn.vonce.sql.uitls.BeanUtil;

import java.io.Serializable;
import java.util.*;

/**
 * JSONArray
 *
 * @author Jovi
 * @email imjovi@qq.com
 * @date 2024/11/22 19:22
 */
public class JSONArray extends JSONParser implements List<Object>, Cloneable, RandomAccess, Serializable {

    private final List<Object> list;

    public JSONArray() {
        this.list = new ArrayList<>();
    }

    public JSONArray(List<Object> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null.");
        }
        this.list = list;
    }

    public JSONArray(int initialCapacity) {
        this.list = new ArrayList<>(initialCapacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        return this.list.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, Object element) {
        this.list.add(index, element);
    }

    @Override
    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        if (clazz != null) {
            List<T> resultList = new ArrayList<>();
            for (Object item : this) {
                if (item instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject) item;
                    resultList.add(BeanUtil.toBean(clazz, jsonObject));
                } else {
                    resultList.add((T) item);
                }
            }
            return resultList;
        }
        return null;
    }

    public static JSONArray parseArray(Object obj) {
        return JSONParser.parseArray(JSONParser.toJSONString(obj));
    }

}
