/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.processor;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.uitls.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public abstract class SqlConstantProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;
    public static final String PREFIX = "$";
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            return true;
        }
        try {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> annotatedElements = env.getElementsAnnotatedWith(typeElement);
                for (Element element : annotatedElements) {
                    TypeElement typeEl;
                    SqlTable sqlTable;
                    if (element.getKind() != ElementKind.CLASS || (sqlTable = (typeEl = (TypeElement)element).getAnnotation(SqlTable.class)) != null && !sqlTable.constant()) continue;
                    List<Element> fieldElements = this.collectFields(typeEl);
                    PackageElement packageElement = (PackageElement)element.getEnclosingElement();
                    String packageName = packageElement.getQualifiedName().toString() + ".sql";
                    String className = element.getSimpleName().toString() + PREFIX;
                    this.generateJavaFile(packageName, className, element, fieldElements, sqlTable);
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "\u5904\u7406\u5f02\u5e38: " + e.getMessage());
        }
        return true;
    }

    private List<Element> collectFields(TypeElement typeElement) {
        ArrayList<Element> fields = new ArrayList<Element>();
        TypeElement currentClass = typeElement;
        while (currentClass != null) {
            for (Element element : currentClass.getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                fields.add(element);
            }
            DeclaredType superClassType = (DeclaredType)currentClass.getSuperclass();
            if (superClassType.getKind() == TypeKind.NONE || OBJECT_CLASS_NAME.equals(superClassType.toString())) break;
            currentClass = (TypeElement)superClassType.asElement();
        }
        return fields;
    }

    private void generateJavaFile(String packageName, String className, Element element, List<Element> fields, SqlTable sqlTable) throws IOException {
        JavaFileObject fileObject = this.filer.createSourceFile(packageName + "." + className, element);
        try (Writer writer = fileObject.openWriter();){
            writer.write(this.buildCode(element, fields, sqlTable, packageName, className));
        }
    }

    public abstract String getTableRemarks(Element var1);

    public abstract String getFieldRemarks(String var1);

    private String buildCode(Element element, List<Element> fieldElements, SqlTable sqlTable, String packageName, String className) {
        StringBuilder code = new StringBuilder(2048);
        try {
            String schema = "";
            String tableAlias = "";
            String tableRemarks = this.getTableRemarks(element);
            String tableName = element.getSimpleName().toString();
            if (sqlTable != null) {
                schema = sqlTable.schema();
                tableName = sqlTable.value();
                tableAlias = sqlTable.alias();
            }
            if (StringUtil.isEmpty(tableAlias)) {
                tableAlias = tableName;
            }
            code.append("/** The code is generated by the FlexSQL. Do not modify!*/\n\n").append("package ").append(packageName).append(";\n\n").append("import cn.vonce.sql.bean.Column;\n\n").append("public class ").append(className).append(" {\n\n").append("\tpublic static final String _schema = \"").append(this.escape(schema)).append("\";\n").append("\tpublic static final String _tableName = \"").append(this.escape(tableName)).append("\";\n").append("\tpublic static final String _tableAlias = \"").append(this.escape(tableAlias)).append("\";\n").append("\tpublic static final String _remarks = \"").append(this.escape(tableRemarks)).append("\";\n").append("\tpublic static final String _all = \"").append(this.escape(tableAlias)).append(".*\";\n").append("\tpublic static final String _count = \"COUNT(*)\";\n");
            boolean mapUsToCc = sqlTable != null && sqlTable.mapUsToCc();
            for (Element fieldElement : fieldElements) {
                String fieldName;
                SqlColumn sqlColumn = fieldElement.getAnnotation(SqlColumn.class);
                if (sqlColumn != null && sqlColumn.ignore()) continue;
                String sqlFieldName = fieldName = fieldElement.getSimpleName().toString();
                if (sqlColumn != null && StringUtil.isNotEmpty(sqlColumn.value())) {
                    sqlFieldName = sqlColumn.value();
                } else if (mapUsToCc) {
                    sqlFieldName = StringUtil.humpToUnderline(fieldName);
                }
                String sqlFieldRemarks = this.getFieldRemarks(fieldName);
                code.append("\tpublic static final String ").append(sqlFieldName).append(" = \"").append(this.escape(sqlFieldName)).append("\";\n");
                code.append("\tpublic static final Column ").append(sqlFieldName).append("$ = new Column(true, _tableAlias, ").append(sqlFieldName).append(", \"\", \"").append(this.escape(sqlFieldRemarks)).append("\");\n");
            }
            code.append("\n}");
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "\u751f\u6210\u4ee3\u7801\u9519\u8bef: " + e.getMessage());
        }
        return code.toString();
    }

    private String escape(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("\"", "\\\"").replace("\n", "\\n");
    }
}

