/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.uitls;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class DateUtil {
    public static String getInterval(String createTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        java.util.Date date = sdf.parse(createTime, pos);
        return DateUtil.getInterval(date);
    }

    public static String getInterval(java.util.Date date) {
        String interval = null;
        long time = (new java.util.Date().getTime() - date.getTime()) / 1000L;
        interval = time > 0L && time < 60L ? time + "\u79d2\u524d" : (time > 60L && time < 3600L ? time / 60L + "\u5206\u949f\u524d" : (time >= 3600L && time < 86400L ? time / 3600L + "\u5c0f\u65f6\u524d" : (time >= 86400L && time < 172800L ? "\u6628\u5929" : (time >= 172800L && time < 259200L ? "\u524d\u5929" : DateUtil.dateToString(date, "yyyy-MM-dd HH:mm")))));
        return interval;
    }

    public static String dateToString(java.util.Date date) {
        if (date != null) {
            return DateUtil.dateToString(date, "yyyy-MM-dd HH:mm:ss");
        }
        return "";
    }

    public static String dateToString(java.util.Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date != null) {
            return sdf.format(date);
        }
        return "";
    }

    public static java.util.Date stringToDate(String createTime) {
        return DateUtil.stringToDate(createTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static java.util.Date stringToDate(String createTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        return sdf.parse(createTime, pos);
    }

    public static int differentDays(java.util.Date date1, java.util.Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static LocalDateTime strTimeToLocalDateTime(String dateTime) {
        DateTimeFormatter FORMATTER_FULL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("+8"));
        return LocalDateTime.parse(dateTime, FORMATTER_FULL);
    }

    public static LocalDateTime strTimeToLocalDateTime(String dateTime, DateTimeFormatter dateTimeFormatter) {
        return LocalDateTime.parse(dateTime, dateTimeFormatter);
    }

    public static LocalDateTime dateToLocalDateTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static LocalDate dateToLocalDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static LocalTime dateToLocalTime(java.util.Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalTime();
    }

    public static java.util.Date localDateTimeToDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }

    public static java.util.Date localDateToDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }

    public static java.util.Date localTimeToDate(LocalTime localTime, LocalDate localDate) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return java.util.Date.from(instant);
    }

    public static String unifyDateToString(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return date.toString();
        }
        if (date instanceof java.util.Date || date instanceof Date || date instanceof Timestamp || date instanceof Time) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(date);
        }
        if (date instanceof LocalDateTime) {
            DateTimeFormatter FORMATTER_FULL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.of("+8"));
            return ((LocalDateTime)date).format(FORMATTER_FULL);
        }
        if (date instanceof LocalDate) {
            return ((LocalDate)date).format(DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("+8")));
        }
        if (date instanceof LocalTime) {
            return ((LocalTime)date).format(DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.of("+8")));
        }
        return null;
    }

    public static String unifyDateToString(Object date, String format) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return date.toString();
        }
        if (date instanceof java.util.Date || date instanceof Date || date instanceof Timestamp || date instanceof Time) {
            return new SimpleDateFormat(format).format(date);
        }
        if (date instanceof LocalDateTime) {
            DateTimeFormatter FORMATTER_FULL = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("+8"));
            return ((LocalDateTime)date).format(FORMATTER_FULL);
        }
        if (date instanceof LocalDate) {
            return ((LocalDate)date).format(DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("+8")));
        }
        if (date instanceof LocalTime) {
            return ((LocalTime)date).format(DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("+8")));
        }
        return null;
    }

    public static Long unifyDateToTimestamp(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.util.Date || date instanceof Date || date instanceof Timestamp || date instanceof Time) {
            java.util.Date utilDate = (java.util.Date)date;
            return utilDate.getTime();
        }
        if (date instanceof LocalDateTime) {
            return ((LocalDateTime)date).toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        if (date instanceof LocalDate) {
            return ((LocalDate)date).atStartOfDay(ZoneOffset.of("+8")).toInstant().toEpochMilli();
        }
        if (date instanceof LocalTime) {
            return ((LocalTime)date).atDate(LocalDate.now()).atZone(ZoneOffset.of("+8")).toInstant().toEpochMilli();
        }
        return null;
    }

    public Integer getLastMonthEndDay() {
        LocalDate with = LocalDate.now().plusMonths(-1L).with(TemporalAdjusters.firstDayOfMonth());
        return with.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
    }

    public static Integer getNextMonthEndDay() {
        LocalDate with = LocalDate.now().plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        return with.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
    }

    public static List<String[]> getCalendarTable(Integer index) {
        long length;
        LocalDate months = LocalDate.now().plusMonths(index.intValue());
        LocalDate currentMonthFirstDay = months.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate currentMonthEndDay = months.with(TemporalAdjusters.lastDayOfMonth());
        int days = LocalDate.now().lengthOfMonth();
        int dayOfWeek = currentMonthFirstDay.getDayOfWeek().getValue();
        LocalDate calendarFirstDay = months.minus(dayOfWeek - 1, ChronoUnit.DAYS);
        LocalDate calendarEndDay = currentMonthEndDay.plus(42 - days - (dayOfWeek - 1), ChronoUnit.DAYS);
        ArrayList<String[]> localDateList = new ArrayList<String[]>();
        for (long i = length = calendarEndDay.toEpochDay() - calendarFirstDay.toEpochDay(); i >= 0L; --i) {
            String[] dataCalendarDTO = new String[2];
            LocalDate localDate = calendarEndDay.minusDays(i);
            DateTimeFormatter DATE_STR = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("+8"));
            dataCalendarDTO[0] = localDate.format(DATE_STR);
            dataCalendarDTO[1] = localDate.getDayOfWeek().getValue() + "";
            localDateList.add(dataCalendarDTO);
        }
        return localDateList;
    }

    public static List<LocalDate> getMiddleAllDate(LocalDate begin, LocalDate end) {
        long length;
        ArrayList<LocalDate> localDateList = new ArrayList<LocalDate>();
        for (long i = length = end.toEpochDay() - begin.toEpochDay(); i >= 0L; --i) {
            localDateList.add(end.minusDays(i));
        }
        return localDateList;
    }

    public static String getYesterdayByFormat(Integer offSet, String timeFormat) {
        return LocalDateTime.now().plusDays(offSet.intValue()).format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static java.util.Date getMonday() {
        return DateUtil.getMonday(null);
    }

    public static java.util.Date getMonday(java.util.Date date) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        if (date != null) {
            calendar.setTimeInMillis(date.getTime());
        } else {
            calendar.setTimeInMillis(System.currentTimeMillis());
        }
        calendar.set(7, 2);
        return calendar.getTime();
    }
}

