/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.java.processor;

import cn.vonce.sql.processor.SqlConstantProcessor;
import cn.vonce.sql.uitls.JavaParserUtil;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import java.io.File;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"cn.vonce.sql.annotation.SqlTable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class JavaSqlConstantProcessor
extends SqlConstantProcessor {
    private Messager messager;
    private final ThreadLocal<List<FieldDeclaration>> fieldDeclarationList = ThreadLocal.withInitial(() -> null);
    private String sourceRootCache;
    private boolean isWindows;

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            boolean bl = super.process(annotations, env);
            return bl;
        }
        finally {
            this.fieldDeclarationList.remove();
        }
    }

    public String getTableRemarks(Element element) {
        try {
            String sourceRoot = this.getSourceRoot();
            if (sourceRoot == null) {
                return "";
            }
            Path javaFilePath = this.buildJavaFilePath(element, sourceRoot);
            if (!Files.exists(javaFilePath, new LinkOption[0])) {
                return "";
            }
            JavaParserUtil.Declaration declaration = JavaParserUtil.getFieldDeclarationList((String)sourceRoot, (String)javaFilePath.toString());
            TypeDeclaration typeDeclaration = declaration.getTypeDeclaration();
            this.fieldDeclarationList.set(declaration.getFieldDeclarationList());
            if (typeDeclaration != null && typeDeclaration.getComment().isPresent()) {
                return JavaParserUtil.getCommentContent((String)((Comment)typeDeclaration.getComment().get()).getContent());
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "\u83b7\u53d6\u8868\u6ce8\u91ca\u5931\u8d25: " + e.getMessage());
        }
        return "";
    }

    public String getFieldRemarks(String sqlFieldName) {
        try {
            List<FieldDeclaration> fields = this.fieldDeclarationList.get();
            if (fields != null) {
                return JavaParserUtil.getFieldCommentContent((String)sqlFieldName, fields);
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "\u83b7\u53d6\u5b57\u6bb5\u6ce8\u91ca\u5931\u8d25: " + e.getMessage());
        }
        return "";
    }

    private String getSourceRoot() {
        if (this.sourceRootCache != null) {
            return this.sourceRootCache;
        }
        try {
            Path srcRootPath;
            String targetClasses;
            int index;
            String path = ((Object)((Object)this)).getClass().getClassLoader().getResource("").getFile();
            path = URLDecoder.decode(path, "UTF-8");
            File classDir = new File(path);
            if (classDir.exists() && (index = path.indexOf(targetClasses = this.isWindows ? "\\target\\classes\\" : "/target/classes/")) != -1) {
                this.sourceRootCache = path.substring(0, index);
            }
            if (this.sourceRootCache == null) {
                this.sourceRootCache = new File("").getAbsolutePath();
            }
            if (Files.exists(srcRootPath = Paths.get(this.sourceRootCache, "src", "main", "java"), new LinkOption[0])) {
                this.sourceRootCache = srcRootPath.toString();
                return this.sourceRootCache;
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "\u83b7\u53d6\u6e90\u7801\u6839\u76ee\u5f55\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    private Path buildJavaFilePath(Element element, String sourceRoot) {
        PackageElement packageElement = (PackageElement)element.getEnclosingElement();
        String packagePath = packageElement.getQualifiedName().toString().replace(".", File.separator);
        return Paths.get(sourceRoot, packagePath, element.getSimpleName() + ".java");
    }
}

