/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.solon.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.java.config.BaseAutoCreateTableListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.annotation.Component;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.EventListener;

@Component
public class SolonAutoCreateTableListener
extends BaseAutoCreateTableListener
implements EventListener<AppLoadEndEvent> {
    private AppLoadEndEvent appLoadEndEvent;
    private final Lock lock = new ReentrantLock();

    public void onEvent(AppLoadEndEvent appLoadEndEvent) {
        this.appLoadEndEvent = appLoadEndEvent;
        SqlBeanConfig sqlBeanConfig = appLoadEndEvent.context().getBeansOfType(SqlBeanConfig.class).stream().findFirst().orElse(null);
        if (sqlBeanConfig == null || sqlBeanConfig.getAutoCreate()) {
            this.lock.lock();
            try {
                new Thread(() -> this.processSqlBeanServices()).start();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public <T> T getBean(String name) {
        return (T)this.appLoadEndEvent.context().getBean(name);
    }

    public <T> List<T> getBeansForType(Class<T> baseType) {
        return this.appLoadEndEvent.context().getBeansOfType(baseType);
    }

    public List<String> getBeanNamesForType(Class<?> baseType) {
        List beanList = this.appLoadEndEvent.context().getBeansOfType(baseType);
        if (beanList != null) {
            ArrayList<String> beanNames = new ArrayList<String>();
            for (Object bean : beanList) {
                beanNames.add(bean.getClass().getName());
            }
            return beanNames;
        }
        return null;
    }
}

