/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.solon.config;

import cn.vonce.sql.java.annotation.DbTransactional;
import cn.vonce.sql.java.config.BaseAutoConfigMultiDataSource;
import cn.vonce.sql.solon.annotation.EnableAutoConfigMultiDataSource;
import cn.vonce.sql.solon.config.AutoConfigSolon;
import cn.vonce.sql.solon.datasource.DynamicDataSource;
import cn.vonce.sql.solon.datasource.TransactionalInterceptor;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.aspect.Interceptor;

public class AutoConfigMultiDataSource
extends BaseAutoConfigMultiDataSource
implements BeanBuilder {
    private AppContext appContext;
    private Map<String, Object> propertyMap;

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getProperty(String key) {
        return this.appContext.cfg().get(key);
    }

    public String getDataSourceType() {
        return "solon.datasource.type";
    }

    public String getDataSourcePrefix() {
        return "solon.datasource.flexsql";
    }

    public void doBuild(Class clz, BeanWrap bw, Annotation anno) throws Throwable {
        this.appContext = bw.context();
        EnableAutoConfigMultiDataSource enableAutoConfigMultiDataSource = (EnableAutoConfigMultiDataSource)anno;
        String defaultDataSource = null;
        LinkedHashSet<String> dataSourceNameSet = new LinkedHashSet<String>();
        String dataSourcePrefix = this.getDataSourcePrefix();
        this.propertyMap = new HashMap<String, Object>();
        for (Map.Entry entry : this.appContext.cfg().entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(key = (String)entry.getKey()).startsWith(dataSourcePrefix)) continue;
            key = key.substring(key.indexOf(dataSourcePrefix) + dataSourcePrefix.length() + 1);
            key = key.substring(0, key.indexOf("."));
            dataSourceNameSet.add(key);
            if (defaultDataSource == null) {
                defaultDataSource = key;
            }
            this.propertyMap.put((String)entry.getKey(), entry.getValue());
        }
        String anonDefaultDataSource = enableAutoConfigMultiDataSource.defaultDataSource();
        if (anonDefaultDataSource != null && StringUtil.isNotBlank((Object)anonDefaultDataSource)) {
            defaultDataSource = anonDefaultDataSource;
        }
        super.config(dataSourceNameSet, defaultDataSource, (defaultTargetDataSource, dataSourceMap) -> {
            DynamicDataSource dynamicDataSource = new DynamicDataSource();
            dynamicDataSource.setDefaultTargetDataSource(defaultTargetDataSource);
            dynamicDataSource.setTargetDataSources(dataSourceMap);
            BeanWrap beanWrap = bw.context().wrap("dynamicDataSource", (Object)dynamicDataSource);
            bw.context().putWrap(DataSource.class, beanWrap);
            bw.context().beanInterceptorAdd(DbTransactional.class, (Interceptor)new TransactionalInterceptor());
            AutoConfigSolon.init(beanWrap);
        });
    }
}

