/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.solon.datasource;

import cn.vonce.sql.java.annotation.DbSource;
import cn.vonce.sql.java.annotation.DbSwitch;
import cn.vonce.sql.java.datasource.DataSourceContextHolder;
import cn.vonce.sql.java.datasource.TransactionalContextHolder;
import cn.vonce.sql.java.enumerate.DbRole;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Method;
import java.util.Random;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;

public class DataSourceInterceptor
implements Interceptor {
    public Object doIntercept(Invocation inv) throws Throwable {
        Class<?> clazz = inv.target().getClass();
        String xid = TransactionalContextHolder.getXid();
        if (clazz.isAnnotationPresent(DbSource.class) && StringUtil.isBlank((Object)xid)) {
            String methodName = inv.method().getMethod().getName();
            Class<?>[] parameterTypes = inv.method().getMethod().getParameterTypes();
            String dataSource = null;
            DbSource dbSource = clazz.getAnnotation(DbSource.class);
            try {
                Method method = clazz.getMethod(methodName, parameterTypes);
                DbSwitch dbSwitch = method.getAnnotation(DbSwitch.class);
                dataSource = dbSwitch != null && dbSwitch.value() == DbRole.SLAVE && dbSource.slave().length > 0 ? (dbSource.slave().length == 1 ? dbSource.slave()[0] : dbSource.slave()[new Random().nextInt(dbSource.slave().length)]) : dbSource.master();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DataSourceContextHolder.setDataSource(dataSource);
        }
        Object result = inv.invoke();
        DataSourceContextHolder.clearDataSource();
        return result;
    }
}

