/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.solon.datasource;

import cn.vonce.sql.java.datasource.ConnectionContextHolder;
import cn.vonce.sql.java.datasource.ConnectionProxy;
import cn.vonce.sql.java.datasource.DataSourceContextHolder;
import cn.vonce.sql.java.datasource.TransactionalContextHolder;
import cn.vonce.sql.uitls.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import org.noear.solon.data.datasource.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    public String determineCurrentKey() {
        return DataSourceContextHolder.getDataSource();
    }

    public Connection getConnection() throws SQLException {
        String xid = TransactionalContextHolder.getXid();
        String ds = DataSourceContextHolder.getDataSource();
        if (StringUtil.isEmpty((Object)xid)) {
            return this.determineCurrentTarget().getConnection();
        }
        return this.getConnectionProxy(ds, null, null);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String xid = TransactionalContextHolder.getXid();
        String ds = DataSourceContextHolder.getDataSource();
        if (StringUtil.isEmpty((Object)xid)) {
            return this.determineCurrentTarget().getConnection(username, password);
        }
        return this.getConnectionProxy(ds, username, password);
    }

    private ConnectionProxy getConnectionProxy(String ds, String username, String password) throws SQLException {
        ConnectionProxy connectionProxy;
        if (StringUtil.isBlank((Object)ds)) {
            ds = "default";
        }
        if ((connectionProxy = ConnectionContextHolder.getConnection((String)ds)) == null) {
            Connection connection = StringUtil.isBlank((Object)username) && StringUtil.isBlank((Object)password) ? this.determineCurrentTarget().getConnection() : this.determineCurrentTarget().getConnection(username, password);
            connectionProxy = new ConnectionProxy(ds, connection);
            ConnectionContextHolder.setConnection((String)ds, (ConnectionProxy)connectionProxy);
        }
        return connectionProxy;
    }
}

