/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import cn.vonce.sql.java.mapper.MybatisSqlBeanMapperInterceptor;
import cn.vonce.sql.spring.config.ConditionalOnUseMybatis;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.List;
import java.util.logging.Logger;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

public class MybatisAutoConfig {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Autowired(required=false)
    private SqlSessionFactoryBean sqlSessionFactoryBean;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;

    @Bean
    @Conditional(value={ConditionalOnUseMybatis.class})
    public Interceptor interceptor() throws Exception {
        List interceptorList;
        MybatisSqlBeanMapperInterceptor mybatisMapperInterceptor = new MybatisSqlBeanMapperInterceptor();
        SqlSessionFactory sqlSessionFactory = null;
        if (this.sqlSessionFactoryBean != null) {
            sqlSessionFactory = this.sqlSessionFactoryBean.getObject();
        } else {
            try {
                sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(SqlSessionFactory.class);
            }
            catch (Exception e) {
                this.logger.warning(String.format("interceptor\uff1a%s", e.getMessage()));
            }
        }
        if (sqlSessionFactory != null && (interceptorList = sqlSessionFactory.getConfiguration().getInterceptors()) != null && !interceptorList.stream().anyMatch(item -> item instanceof MybatisSqlBeanMapperInterceptor)) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)mybatisMapperInterceptor);
        }
        return mybatisMapperInterceptor;
    }

    @Bean(name={"sqlBeanConfigForMybatis"})
    @Conditional(value={ConditionalOnUseMybatis.class})
    public SqlBeanMeta sqlBeanMeta() throws Exception {
        SqlSessionFactory sqlSessionFactory = null;
        if (this.sqlSessionFactoryBean != null) {
            sqlSessionFactory = this.sqlSessionFactoryBean.getObject();
        } else {
            try {
                sqlSessionFactory = (SqlSessionFactory)this.beanFactory.getBean(SqlSessionFactory.class);
            }
            catch (Exception e) {
                this.logger.warning(String.format("sqlBeanMeta\uff1a%s", e.getMessage()));
            }
        }
        Connection connection = sqlSessionFactory.getConfiguration().getEnvironment().getDataSource().getConnection();
        SqlBeanMeta sqlBeanMeta = SqlBeanMeta.build((SqlBeanConfig)this.sqlBeanConfig, (DatabaseMetaData)connection.getMetaData());
        connection.close();
        return sqlBeanMeta;
    }
}

