/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanMeta;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

public class SpringJdbcAutoConfig {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;

    @Bean(name={"sqlBeanMetaForSpringJdbc"})
    public SqlBeanMeta sqlBeanMeta() {
        try {
            Connection connection = this.jdbcTemplate.getDataSource().getConnection();
            SqlBeanMeta sqlBeanMeta = SqlBeanMeta.build((SqlBeanConfig)this.sqlBeanConfig, (DatabaseMetaData)connection.getMetaData());
            connection.close();
            return sqlBeanMeta;
        }
        catch (SQLException e) {
            this.logger.warning(String.format("sqlBeanMeta\uff1a%s", e.getMessage()));
            return null;
        }
    }
}

