/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.supercode.core.util;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class FreemarkerUtil {
    private static FreemarkerUtil freemarkerUtil;
    private static Configuration configuration;

    private FreemarkerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FreemarkerUtil getInstance(String versionNo, String templatePath) {
        if (null != freemarkerUtil) return freemarkerUtil;
        Class<FreemarkerUtil> clazz = FreemarkerUtil.class;
        synchronized (FreemarkerUtil.class) {
            if (null != freemarkerUtil) return freemarkerUtil;
            configuration = new Configuration(new Version(versionNo));
            configuration.setClassForTemplateLoading(FreemarkerUtil.class, templatePath);
            freemarkerUtil = new FreemarkerUtil();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return freemarkerUtil;
        }
    }

    public static FreemarkerUtil getInstance(String versionNo, File templatePath) throws IOException {
        if (null == freemarkerUtil) {
            configuration = new Configuration(new Version(versionNo));
            configuration.setDirectoryForTemplateLoading(templatePath);
            freemarkerUtil = new FreemarkerUtil();
        }
        return freemarkerUtil;
    }

    public static FreemarkerUtil getInstance(String versionNo, Object servletContext, String templatePath) throws IOException {
        if (null == freemarkerUtil) {
            configuration = new Configuration(new Version(versionNo));
            configuration.setServletContextForTemplateLoading(servletContext, templatePath);
            freemarkerUtil = new FreemarkerUtil();
        }
        return freemarkerUtil;
    }

    private Template getTemplate(String templateName) {
        try {
            return configuration.getTemplate(templateName);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void sprint(Object dataModel, String templateName) {
        try {
            this.getTemplate(templateName).process(dataModel, (Writer)new PrintWriter(System.out));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fprint(Object dataModel, String templateName, String filePath) {
        try {
            this.getTemplate(templateName).process(dataModel, (Writer)new FileWriter(filePath));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fprint(Object dataModel, String templateName, File filePath) {
        try {
            this.getTemplate(templateName).process(dataModel, (Writer)new FileWriter(filePath));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

