/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.supercode.core.helper;

import cn.vonce.sql.annotation.SqlColumn;
import cn.vonce.sql.annotation.SqlDefaultValue;
import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Create;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.enumerate.FillWith;
import cn.vonce.sql.enumerate.IdType;
import cn.vonce.sql.helper.SqlHelper;
import cn.vonce.sql.service.TableService;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import cn.vonce.supercode.core.config.GenerateConfig;
import cn.vonce.supercode.core.enumeration.JdbcDaoType;
import cn.vonce.supercode.core.enumeration.JdbcDocType;
import cn.vonce.supercode.core.enumeration.TemplateType;
import cn.vonce.supercode.core.map.JdbcMapJava;
import cn.vonce.supercode.core.model.ClassInfo;
import cn.vonce.supercode.core.model.FieldInfo;
import cn.vonce.supercode.core.util.ClassUtil;
import cn.vonce.supercode.core.util.FreemarkerUtil;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class GenerateHelper {
    public static void build(GenerateConfig config, TableService tableService) {
        List<TableInfo> tableInfoList = GenerateHelper.getTableInfoList(tableService);
        Map<String, String> filePaths = GenerateHelper.getFilePaths(config);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(3, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        int num = 10;
        int size = tableInfoList.size() % num == 0 ? tableInfoList.size() / num : tableInfoList.size() / num + 1;
        int i = 0;
        while (i < size) {
            int finalI = i++;
            pool.execute(() -> {
                List<ClassInfo> classInfoList = GenerateHelper.getClassInfoList(config, tableInfoList.subList(num * finalI, finalI == size - 1 ? tableInfoList.size() : num * finalI + num), tableService);
                try {
                    GenerateHelper.make(config, filePaths, classInfoList);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        pool.shutdown();
    }

    public static void build(GenerateConfig config, TableInfo tableInfo, List<ColumnInfo> columnInfoList) {
        Map<String, String> filePaths = GenerateHelper.getFilePaths(config);
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        classInfoList.add(GenerateHelper.getClassInfo(config, tableInfo, columnInfoList));
        try {
            GenerateHelper.make(config, filePaths, classInfoList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void build(GenerateConfig config, DbType dbType, String ... packageNames) {
        GenerateHelper.build(config, dbType, false, packageNames);
    }

    public static void build(GenerateConfig config, DbType dbType, boolean sqlToUpperCase, String ... packageNames) {
        if (packageNames == null || packageNames.length == 0) {
            return;
        }
        ArrayList beanClassList = new ArrayList();
        for (String packageName : packageNames) {
            beanClassList.addAll(ClassUtil.getClasses(packageName));
        }
        for (Class clazz : beanClassList) {
            GenerateHelper.build(config, dbType, sqlToUpperCase, clazz);
        }
    }

    public static void build(GenerateConfig config, DbType dbType, List<Class<?>> beanClassList) {
        GenerateHelper.build(config, dbType, false, beanClassList);
    }

    public static void build(GenerateConfig config, DbType dbType, boolean sqlToUpperCase, List<Class<?>> beanClassList) {
        if (beanClassList == null || beanClassList.size() == 0) {
            return;
        }
        for (Class<?> beanClass : beanClassList) {
            GenerateHelper.build(config, dbType, sqlToUpperCase, beanClass);
        }
    }

    public static void build(GenerateConfig config, DbType dbType, Class<?> beanClass) {
        GenerateHelper.build(config, dbType, false, beanClass);
    }

    public static void build(GenerateConfig config, DbType dbType, boolean sqlToUpperCase, Class<?> beanClass) {
        SqlBeanDB sqlBeanDB = new SqlBeanDB();
        sqlBeanDB.setDbType(dbType);
        SqlBeanConfig sqlBeanConfig = new SqlBeanConfig();
        sqlBeanConfig.setToUpperCase(Boolean.valueOf(sqlToUpperCase));
        sqlBeanDB.setSqlBeanConfig(sqlBeanConfig);
        Map<String, String> filePaths = GenerateHelper.getFilePaths(config);
        Table table = SqlBeanUtil.getTable(beanClass);
        SqlTable sqlTable = SqlBeanUtil.getSqlTable(beanClass);
        TableInfo tableInfo = new TableInfo();
        tableInfo.setName(table.getName());
        tableInfo.setRemarks(sqlTable != null ? sqlTable.remarks() : "");
        List fieldList = SqlBeanUtil.getBeanAllField(beanClass);
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = (Field)fieldList.get(i);
            if (SqlBeanUtil.isIgnore((Field)field)) continue;
            columnInfoList.add(SqlBeanUtil.buildColumnInfo((SqlBeanDB)sqlBeanDB, (Field)field, (SqlTable)sqlTable, (SqlColumn)field.getAnnotation(SqlColumn.class)));
        }
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        ClassInfo classInfo = GenerateHelper.getClassInfo(config, tableInfo, columnInfoList);
        Create create = new Create();
        create.setSqlBeanDB(sqlBeanDB);
        create.setTable(beanClass);
        create.setBeanClass(beanClass);
        classInfo.setSql(SqlHelper.buildCreateSql((Create)create));
        classInfoList.add(classInfo);
        try {
            GenerateHelper.make(config, filePaths, classInfoList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<TableInfo> getTableInfoList(TableService tableService) {
        List tableInfoList = tableService.getTableList(null);
        if (tableInfoList == null || tableInfoList.isEmpty()) {
            return null;
        }
        return tableInfoList;
    }

    public static List<ClassInfo> getClassInfoList(GenerateConfig config, List<TableInfo> tableInfoList, TableService tableService) {
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        for (TableInfo tableInfo : tableInfoList) {
            List columnInfoList = tableService.getColumnInfoList(tableInfo.getName());
            classInfoList.add(GenerateHelper.getClassInfo(config, tableInfo, columnInfoList));
        }
        return classInfoList;
    }

    public static ClassInfo getClassInfo(GenerateConfig config, TableInfo tableInfo, List<ColumnInfo> columnInfoList) {
        Date date = new Date();
        ClassInfo classInfo = new ClassInfo();
        classInfo.setConfig(config);
        String newTableName = config.isBePrefix() && StringUtil.isNotEmpty((Object)config.getPrefix()) && tableInfo.getName().indexOf(config.getPrefix()) == 0 ? tableInfo.getName().substring(config.getPrefix().length()) : (config.isBePrefix() ? tableInfo.getName().substring(tableInfo.getName().indexOf("_") + 1) : tableInfo.getName());
        classInfo.setClassName(newTableName.substring(0, 1).toUpperCase() + StringUtil.underlineToHump((String)newTableName.substring(1)));
        classInfo.setTableInfo(tableInfo);
        classInfo.setDate(date);
        if (columnInfoList != null && !columnInfoList.isEmpty()) {
            ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
            String baseClassPath = "";
            List<Object> baseClassFiledList = null;
            HashSet<String> otherTypeSet = new HashSet<String>();
            if (config.getBaseClass() != null) {
                baseClassPath = config.getBaseClass().getName();
                List fieldList = SqlBeanUtil.getBeanAllField(config.getBaseClass());
                baseClassFiledList = fieldList.stream().map(item -> item.getName()).collect(Collectors.toList());
            } else if (StringUtil.isNotBlank((Object)config.getBaseClassName())) {
                baseClassPath = config.getBaseClassName().indexOf(".") > -1 ? config.getBaseClassName() : config.getBasePackage() + (StringUtil.isNotBlank((Object)config.getModule()) ? "." + config.getModule() : "") + "." + config.getBaseClassName();
                baseClassFiledList = Arrays.asList(config.getBaseClassFields());
            }
            if (StringUtil.isNotBlank((Object)baseClassPath)) {
                classInfo.setBaseClassName(baseClassPath.substring(baseClassPath.lastIndexOf(".") + 1));
                otherTypeSet.add(baseClassPath);
            }
            for (ColumnInfo columnInfo : columnInfoList) {
                String columnName = StringUtil.underlineToHump((String)columnInfo.getName());
                Class<?> clazz = JdbcMapJava.getJavaType(columnInfo.getType());
                FieldInfo filedInfo = new FieldInfo();
                filedInfo.setColumnInfo(columnInfo);
                filedInfo.setName(columnName);
                filedInfo.setTypeName(clazz.getSimpleName());
                filedInfo.setTypeFullName(clazz.getName());
                if (columnInfo.getPk().booleanValue()) {
                    classInfo.setId(filedInfo);
                    if (filedInfo.getTypeName().equals("Long") || filedInfo.getTypeName().equals("String")) {
                        otherTypeSet.add(IdType.class.getName());
                    }
                }
                filedInfo.setCreateTime(clazz.getSimpleName().equals("Date") && (columnInfo.getName().toLowerCase().indexOf("create") > -1 || columnInfo.getRemarks().equals("\u521b\u5efa\u65f6\u95f4")));
                filedInfo.setUpdateTime(clazz.getSimpleName().equals("Date") && (columnInfo.getName().toLowerCase().indexOf("update") > -1 || columnInfo.getRemarks().equals("\u66f4\u65b0\u65f6\u95f4")));
                if (filedInfo.getTypeFullName().indexOf("java.lang") == -1) {
                    otherTypeSet.add(filedInfo.getTypeFullName());
                }
                if (filedInfo.isCreateTime() || filedInfo.isUpdateTime()) {
                    otherTypeSet.add(SqlDefaultValue.class.getName());
                    otherTypeSet.add(FillWith.class.getName());
                }
                fieldInfoList.add(filedInfo);
            }
            if (baseClassFiledList != null && baseClassFiledList.size() > 0) {
                block1: for (FieldInfo fieldInfo : fieldInfoList) {
                    for (String string : baseClassFiledList) {
                        if (!fieldInfo.getName().equals(string)) continue;
                        fieldInfo.setIgnore(true);
                        continue block1;
                    }
                }
            }
            if (classInfo.getId() == null) {
                classInfo.setId((FieldInfo)fieldInfoList.get(0));
            }
            classInfo.setFieldInfoList(fieldInfoList);
            classInfo.setOtherTypeSet(otherTypeSet);
        }
        return classInfo;
    }

    private static void make(GenerateConfig config, Map<String, String> filePaths, List<ClassInfo> classInfoList) throws IOException {
        FreemarkerUtil freemarkerUtil = GenerateHelper.getFreemarkerUtil(config);
        for (ClassInfo classInfo : classInfoList) {
            freemarkerUtil.fprint((Object)classInfo, TemplateType.MODEL.getTemplateName(), filePaths.get(TemplateType.MODEL.name()) + File.separator + classInfo.getClassName() + ".java");
            freemarkerUtil.fprint((Object)classInfo, TemplateType.MAPPER.getTemplateName(), filePaths.get(TemplateType.MAPPER.name()) + File.separator + classInfo.getClassName() + (config.getJdbcDaoType() == JdbcDaoType.MyBatis ? "Mapper.java" : "Jdbc.java"));
            freemarkerUtil.fprint((Object)classInfo, TemplateType.SERVICE.getTemplateName(), filePaths.get(TemplateType.SERVICE.name()) + File.separator + classInfo.getClassName() + "Service.java");
            freemarkerUtil.fprint((Object)classInfo, TemplateType.SERVICE_IMPL.getTemplateName(), filePaths.get(TemplateType.SERVICE_IMPL.name()) + File.separator + classInfo.getClassName() + "ServiceImpl.java");
            freemarkerUtil.fprint((Object)classInfo, TemplateType.CONTROLLER.getTemplateName(), filePaths.get(TemplateType.CONTROLLER.name()) + File.separator + classInfo.getClassName() + "Controller.java");
            freemarkerUtil.fprint((Object)classInfo, config.getJdbcDocType().getTemplateName(), filePaths.get(JdbcDocType.class.getSimpleName()) + File.separator + classInfo.getTableInfo().getName() + config.getJdbcDocType().getSuffix());
            if (!StringUtil.isNotBlank((Object)classInfo.getSql())) continue;
            freemarkerUtil.fprint((Object)classInfo, TemplateType.SQL.getTemplateName(), filePaths.get(TemplateType.SQL.name()) + File.separator + classInfo.getTableInfo().getName() + ".sql");
        }
    }

    public static Map<String, String> getFilePaths(GenerateConfig config) {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        String packPath = config.getBasePackage().replace(".", File.separator);
        if (StringUtil.isNotBlank((Object)config.getModule())) {
            packPath = packPath + File.separator + config.getModule();
        }
        String dateString = DateUtil.dateToString((Date)new Date(config.getTimestamp()), (String)"yyyyMMddHHmmss");
        File targetDir = StringUtil.isNotEmpty((Object)config.getTargetPath()) ? new File(config.getTargetPath() + File.separator + dateString) : new File(System.getProperty("user.dir") + File.separator + "generateTarget" + File.separator + dateString);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File modelDir = new File(targetDir.getAbsolutePath() + File.separator + packPath + File.separator + "model");
        File mapperDir = new File(targetDir.getAbsolutePath() + File.separator + packPath + File.separator + (config.getJdbcDaoType() == JdbcDaoType.MyBatis ? "mapper" : "jdbc"));
        File serviceDir = new File(targetDir.getAbsolutePath() + File.separator + packPath + File.separator + "service");
        File serviceImplDir = new File(targetDir.getAbsolutePath() + File.separator + packPath + File.separator + "service" + File.separator + "impl");
        File controllerDir = new File(targetDir.getAbsolutePath() + File.separator + packPath + File.separator + "controller");
        File sqlDocDir = new File(targetDir.getAbsolutePath() + File.separator + "dbDoc");
        File sqlDir = new File(targetDir.getAbsolutePath() + File.separator + "sql");
        modelDir.mkdirs();
        mapperDir.mkdirs();
        serviceDir.mkdirs();
        serviceImplDir.mkdirs();
        controllerDir.mkdirs();
        sqlDocDir.mkdirs();
        sqlDir.mkdirs();
        filePaths.put(TemplateType.MODEL.name(), modelDir.getAbsolutePath());
        filePaths.put(TemplateType.MAPPER.name(), mapperDir.getAbsolutePath());
        filePaths.put(TemplateType.SERVICE.name(), serviceDir.getAbsolutePath());
        filePaths.put(TemplateType.SERVICE_IMPL.name(), serviceImplDir.getAbsolutePath());
        filePaths.put(TemplateType.CONTROLLER.name(), controllerDir.getAbsolutePath());
        filePaths.put(JdbcDocType.class.getSimpleName(), sqlDocDir.getAbsolutePath());
        filePaths.put(TemplateType.SQL.name(), sqlDir.getAbsolutePath());
        return filePaths;
    }

    public static FreemarkerUtil getFreemarkerUtil(GenerateConfig config) throws IOException {
        FreemarkerUtil freemarkerUtil = null;
        if (StringUtil.isNotEmpty((Object)config.getTemplatePath())) {
            File file = new File(config.getTemplatePath());
            freemarkerUtil = FreemarkerUtil.getInstance(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString(), file);
        } else {
            freemarkerUtil = FreemarkerUtil.getInstance(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString(), "/template/");
        }
        return freemarkerUtil;
    }
}

