/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.aspect;

import cn.vonce.common.annotation.LogContent;
import cn.vonce.common.base.BaseController;
import cn.vonce.common.bean.RS;
import cn.vonce.common.enumerate.ResultCode;
import cn.vonce.common.utils.RequestDataUtil;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseControllerAspect {
    private final Logger logger = LoggerFactory.getLogger(BaseControllerAspect.class);

    public AspectData handle(ProceedingJoinPoint pjp) {
        LogContent logContent = pjp.getThis().getClass().getAnnotation(LogContent.class);
        this.logger.info("C\u6267\u884c\u5f00\u59cb\uff1a" + (logContent != null ? "(" + logContent.value() + ")" : "") + pjp.getSignature());
        Stopwatch stopwatch = Stopwatch.createStarted();
        AspectData aspectData = new AspectData();
        try {
            Object[] objects = pjp.getArgs();
            HttpServletRequest request = null;
            for (Object object : objects) {
                if (!(object instanceof HttpServletRequest)) continue;
                request = (HttpServletRequest)object;
            }
            aspectData.setSignature(pjp.getSignature());
            if (request == null && pjp.getTarget() instanceof BaseController) {
                request = ((BaseController)pjp.getTarget()).getRequest();
            }
            if (request != null) {
                aspectData.setUrl(request.getRequestURL().toString());
                aspectData.setHeaders(RequestDataUtil.getHeaders(request));
                aspectData.setParam(RequestDataUtil.getParameters(request.getParameterMap()));
                this.logger.info("\u8bf7\u6c42\u5730\u5740\uff1a" + aspectData.getUrl());
                this.logger.info("\u8bf7\u6c42\u5934\u90e8\uff1a" + aspectData.getHeaders());
                this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + aspectData.getParam());
            }
            aspectData.setResult(pjp.proceed(pjp.getArgs()));
            this.logger.info("C\u6267\u884c\u7ed3\u675f\uff1a" + (logContent != null ? "(" + logContent.value() + ")" : "") + aspectData.getSignature());
            this.logger.info("C\u54cd\u5e94\u5185\u5bb9\uff1a" + aspectData.getResult());
            this.logger.info("C\u6267\u884c\u8017\u65f6\uff1a" + stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) + "(\u6beb\u79d2).");
        }
        catch (Throwable throwable) {
            String msg = "\u7cfb\u7edf\u5f02\u5e38\uff1a" + throwable.getMessage();
            RS rs = new RS();
            rs.setCode(ResultCode.ERROR.getCode());
            rs.setMsg(msg);
            aspectData.setResult(rs);
            this.logger.error(msg);
            throwable.printStackTrace();
        }
        return aspectData;
    }

    public class AspectData {
        private Signature signature;
        private String url;
        private String headers;
        private String param;
        private Object result;

        public String getUrl() {
            return this.url;
        }

        private void setUrl(String url) {
            this.url = url;
        }

        public Signature getSignature() {
            return this.signature;
        }

        private void setSignature(Signature signature) {
            this.signature = signature;
        }

        public String getHeaders() {
            return this.headers;
        }

        private void setHeaders(String headers) {
            this.headers = headers;
        }

        public String getParam() {
            return this.param;
        }

        private void setParam(String param) {
            this.param = param;
        }

        public Object getResult() {
            return this.result;
        }

        private void setResult(Object result) {
            this.result = result;
        }
    }
}

