/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.base;

import cn.vonce.common.bean.RS;
import cn.vonce.common.enumerate.ResultCode;
import cn.vonce.common.utils.FastJsonUtil;
import cn.vonce.common.utils.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;

public class BaseController {
    private final Logger logger = LoggerFactory.getLogger(BaseController.class);
    public ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();
    public ThreadLocal<HttpServletResponse> responseThreadLocal = new ThreadLocal();

    public BaseController() {
    }

    public BaseController(HttpServletRequest request, HttpServletResponse response) {
        this.requestThreadLocal.set(request);
        this.responseThreadLocal.set(response);
    }

    public RS errorHint(String msg) {
        return this.getRS(ResultCode.ERROR.getCode(), msg, null);
    }

    public void errorHintJSONP(String msg) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.ERROR.getCode(), msg, null)));
    }

    public RS badHint(String msg) {
        return this.getRS(ResultCode.BAD.getCode(), msg, null);
    }

    public void badHintJSONP(String msg) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.BAD.getCode(), msg, null)));
    }

    public RS unAuthorizedHint(String msg) {
        return this.getRS(ResultCode.UNAUTHORIZED.getCode(), msg, null);
    }

    public void unAuthorizedHintJSONP(String msg) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.UNAUTHORIZED.getCode(), msg, null)));
    }

    public RS successHint(String msg) {
        return this.getRS(ResultCode.SUCCESS.getCode(), msg, null);
    }

    public void successHintJSONP(String msg) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.SUCCESS.getCode(), msg, null)));
    }

    public RS successHint(String msg, Object data) {
        return this.getRS(ResultCode.SUCCESS.getCode(), msg, data);
    }

    public void successHintJSONP(String msg, Object data) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.SUCCESS.getCode(), msg, data)));
    }

    public RS customHint(RS rs) {
        return rs;
    }

    public void customHintJSONP(RS rs) {
        this.writer(this.toJsonOrJsonp(rs));
    }

    public RS parameterHint(String msg) {
        return this.getRS(ResultCode.PARAMETER.getCode(), msg, null);
    }

    public RS parameterHint(String msg, Object data) {
        return this.getRS(ResultCode.PARAMETER.getCode(), msg, data);
    }

    public void parameterHintJSONP(String msg) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.PARAMETER.getCode(), msg, null)));
    }

    public void parameterHintJSONP(String msg, Object data) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.PARAMETER.getCode(), msg, data)));
    }

    public RS othersHint(String msg) {
        return this.getRS(ResultCode.OTHERS.getCode(), msg, null);
    }

    public void othersHintJSONP(String msg) {
        this.writer(this.toJsonOrJsonp(this.getRS(ResultCode.OTHERS.getCode(), msg, null)));
    }

    private RS getRS(int code, String msg, Object data) {
        RS rs = new RS();
        rs.setCode(code);
        rs.setMsg(msg);
        if (data != null) {
            rs.setData(data);
        }
        return rs;
    }

    public String toJsonOrJsonp(Object object) {
        StringBuffer sb = new StringBuffer();
        String callback = this.getRequest().getParameter("callback");
        if (StringUtil.isNotBlank(callback).booleanValue()) {
            sb.append(callback + "(");
            sb.append(FastJsonUtil.obj2Json(object));
            sb.append(");");
        } else {
            sb.append(FastJsonUtil.obj2Json(object));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writer(String data) {
        HttpServletResponse response = this.getResponse();
        PrintWriter printWriter = null;
        try {
            response.setCharacterEncoding("UTF-8");
            if (StringUtil.isNotEmpty(this.getRequest().getParameter("callback")).booleanValue()) {
                response.setContentType("application/javascript; charset=utf-8");
            } else {
                response.setContentType("application/json; charset=utf-8");
            }
            printWriter = response.getWriter();
            printWriter.write(data);
            this.logger.info(this.getRequest().getServletPath() + " \u7684\u54cd\u5e94\u5185\u5bb9\uff1a" + data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            printWriter.close();
            this.remove();
        }
    }

    public HttpServletRequest getRequest() {
        return this.requestThreadLocal.get();
    }

    @ModelAttribute
    public void setRequest(HttpServletRequest request) {
        this.requestThreadLocal.set(request);
    }

    public HttpServletResponse getResponse() {
        return this.responseThreadLocal.get();
    }

    @ModelAttribute
    public void setResponse(HttpServletResponse response) {
        this.responseThreadLocal.set(response);
    }

    private void remove() {
        this.requestThreadLocal.remove();
        this.responseThreadLocal.remove();
    }
}

