/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class StringUtil {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";

    public static Boolean isNotEmpty(Object str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        return true;
    }

    public static Boolean isEmpty(Object str) {
        if (str == null || "".equals(str)) {
            return true;
        }
        return false;
    }

    public static Boolean isBlank(Object str) {
        if (str != null && str.equals("")) {
            return true;
        }
        return false;
    }

    public static Boolean isNotBlank(Object str) {
        if (str != null && !str.equals("")) {
            return true;
        }
        return false;
    }

    public static String getUUid() {
        String uuid = UUID.randomUUID().toString();
        String uuidStr = uuid.substring(0, 8) + uuid.substring(9, 13) + uuid.substring(14, 18) + uuid.substring(19, 23) + uuid.substring(24);
        return uuidStr;
    }

    public static String randomCode(int length) {
        String base = "1234567890";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String resolvePlaceholders(String text, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    String propVal = params.get(placeholder);
                    if (propVal != null) {
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                        nextIndex = startIndex + propVal.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

