/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import cn.vonce.common.utils.Base64Util;
import cn.vonce.common.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class Base64ImageUtil {
    public static String localImgToBase64(String imgFile) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64Util.encode(data));
    }

    public static byte[] remoteImgToByteArray(String imgURL) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        try {
            URL url = new URL(imgURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(bytes)) != -1) {
                data.write(bytes, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static String remoteImgToBase64(String imgURL) {
        return new String(Base64Util.encode(Base64ImageUtil.remoteImgToByteArray(imgURL)));
    }

    public static byte[] base64ToByteArray(String base64) {
        if (StringUtil.isEmpty(base64)) {
            return null;
        }
        return Base64Util.decode(base64.toCharArray());
    }

    public static InputStream base64ToInputStream(String base64) {
        return new ByteArrayInputStream(Base64ImageUtil.base64ToByteArray(base64));
    }

    public static boolean base64ToImgFile(String base64, String imgFilePath) throws IOException {
        if (StringUtil.isEmpty(base64)) {
            return false;
        }
        byte[] b = Base64Util.decode(base64.toCharArray());
        File file = new File(imgFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Files.write(Paths.get(imgFilePath, new String[0]), b, new OpenOption[0]);
        return true;
    }

    public static String getBase64ImgSuffix(String base64Img) {
        String suffix = null;
        if (base64Img.indexOf("data:image/png;") != -1) {
            suffix = ".png";
        } else if (base64Img.indexOf("data:image/jpeg;") != -1) {
            suffix = ".jpg";
        } else if (base64Img.indexOf("data:image/gif;") != -1) {
            suffix = ".gif";
        } else if (base64Img.indexOf("data:image/x-icon;") != -1) {
            suffix = ".ico";
        }
        return suffix;
    }
}

