/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import cn.vonce.common.utils.IdCardUtil;
import java.util.regex.Pattern;

public class ValidatorUtil {
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,17}$";
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{6,16}$";
    public static final String REGEX_MOBILE = "((\\+86|0086)?\\s*)((134[0-8]\\d{7})|(((13([0-3]|[5-9]))|(14[5-9])|15([0-3]|[5-9])|(16(2|[5-7]))|17([0-3]|[5-8])|18[0-9]|19(1|[8-9]))\\d{8})|(14(0|1|4)0\\d{7})|(1740([0-5]|[6-9]|[10-12])\\d{7}))";
    private static final String REGEX_PHONE_CALL = "^(\\(\\d{3,4}\\)|\\d{3,4}-)?\\d{7,8}(-\\d{1,4})?$";
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String REGEX_URL = "^([hH][tT]{2}[pP]://|[hH][tT]{2}[pP][sS]://)(([A-Za-z0-9-~]+).)+([A-Za-z0-9-~\\/])+$";
    public static final String REGEX_IP_ADDR = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b";
    public static final String REGEX_DETE = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
    private static final String REGEX_SQLINJECT = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|union|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";

    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    public static boolean isPassword(String password) {
        return Pattern.matches(REGEX_PASSWORD, password);
    }

    public static boolean isMobilePhone(String mobilePhone) {
        return Pattern.matches(REGEX_MOBILE, mobilePhone);
    }

    public static boolean isTelePhone(String telePhone) {
        return Pattern.matches(REGEX_PHONE_CALL, telePhone);
    }

    public static boolean isEmail(String email) {
        return Pattern.matches(REGEX_EMAIL, email);
    }

    public static boolean isIDCard(String idCard) {
        return IdCardUtil.validate(idCard).isOk();
    }

    public static boolean isUrl(String url) {
        return Pattern.matches(REGEX_URL, url);
    }

    public static boolean isIPAddress(String ipAddr) {
        return Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }

    public static boolean isSQLInject(String str) {
        Pattern sqlPattern = Pattern.compile(REGEX_SQLINJECT, 2);
        return !sqlPattern.matcher(str).find();
    }

    public static void main(String[] args) {
        String username = "fdsdfsdj";
        System.out.println(ValidatorUtil.isUsername(username));
        System.out.println(ValidatorUtil.isMobilePhone("14768000000"));
        System.out.println(ValidatorUtil.isTelePhone("0596-3370653"));
        System.out.println(ValidatorUtil.isEmail("766255988@qq.com"));
        System.out.println(ValidatorUtil.isIDCard("44082519950510095X"));
        System.out.println(ValidatorUtil.isIPAddress("114.114.114.114"));
        System.out.println(ValidatorUtil.isUrl("https://wwws.sss.com"));
        System.out.println(ValidatorUtil.isMobilePhone("17768006232"));
        System.out.println(ValidatorUtil.isPassword("ssswww222222222"));
        System.out.println(ValidatorUtil.isSQLInject("select1 * from essay where 1=1 "));
    }
}

