/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.utils;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkerUtil {
    private static FreemarkerUtil fk;
    private static Configuration cfg;

    public static FreemarkerUtil getInstance(String freemarkerVersionNo, String templatePath) {
        if (null == fk) {
            cfg = new Configuration(new Version(freemarkerVersionNo));
            cfg.setClassForTemplateLoading(FreemarkerUtil.class, templatePath);
            cfg.setDefaultEncoding("UTF-8");
            fk = new FreemarkerUtil();
        }
        return fk;
    }

    private Template getTemplate(String templateName) {
        try {
            return cfg.getTemplate(templateName);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void print(Map<String, Object> dataModel, String templateName) {
        try {
            this.getTemplate(templateName).process(dataModel, (Writer)new PrintWriter(System.out));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fprint(Map<String, Object> dataModel, String templateName, String filePath) {
        try {
            this.getTemplate(templateName).process(dataModel, (Writer)new FileWriter(new File(filePath)));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writer(Map<String, Object> dataModel, String templateName, Writer writer) {
        try {
            this.getTemplate(templateName).process(dataModel, writer);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

