/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.common.aspect;

import cn.vonce.common.annotation.LogContent;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServiceAspect {
    private final Logger logger = LoggerFactory.getLogger(BaseServiceAspect.class);

    public AspectData handle(ProceedingJoinPoint pjp) throws Throwable {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LogContent logContent = pjp.getThis().getClass().getAnnotation(LogContent.class);
        this.logger.info("\u6267\u884c\u5f00\u59cb\uff1a{}", (Object)((logContent != null ? "(" + logContent.value() + ")" : "") + pjp.getSignature()));
        this.logger.info("\u65b9\u6cd5\u53c2\u6570\uff1a{}", pjp.getArgs());
        AspectData aspectData = new AspectData();
        aspectData.setSignature(pjp.getSignature());
        aspectData.setParams(pjp.getArgs());
        aspectData.setResult(pjp.proceed(pjp.getArgs()));
        this.logger.info("\u6267\u884c\u7ed3\u675f\uff1a{}\uff0c\u8017\u65f6\uff1a{}(\u6beb\u79d2).", (Object)((logContent != null ? "(" + logContent.value() + ")" : "") + pjp.getSignature()), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return aspectData;
    }

    public class AspectData {
        private Signature signature;
        private Object[] params;
        private Object result;

        public Signature getSignature() {
            return this.signature;
        }

        private void setSignature(Signature signature) {
            this.signature = signature;
        }

        public Object[] getParams() {
            return this.params;
        }

        private void setParams(Object[] params) {
            this.params = params;
        }

        public Object getResult() {
            return this.result;
        }

        private void setResult(Object result) {
            this.result = result;
        }
    }
}

